/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.support.TokenType;
import java.nio.charset.StandardCharsets;

public class Token {
    private final byte[] serialized;
    private final TokenType type;
    private final int start;
    private int end;
    private boolean hasValue;

    public Token(byte[] serialized, int len, Token prev, TokenType required) {
        this(serialized, len, prev.end + (prev.type == TokenType.KEY ? 2 : 1), required);
    }

    public Token(byte[] serialized, int len, int cur, TokenType required) {
        this.serialized = serialized;
        if (cur >= len) {
            throw new IllegalArgumentException("Invalid header composition");
        }
        if (serialized[cur] == 32) {
            this.type = TokenType.SPACE;
            this.start = cur;
            this.end = cur;
            while (serialized[++cur] == 32) {
                this.end = cur;
            }
        } else if (serialized[cur] == 13) {
            this.mustBeCrlf(len, cur);
            this.type = TokenType.CRLF;
            this.start = cur;
            this.end = cur + 1;
        } else {
            if (required == TokenType.CRLF || required == TokenType.SPACE) {
                throw new IllegalArgumentException("Invalid header composition");
            }
            byte ender1 = 13;
            byte ender2 = 13;
            if (required == null || required == TokenType.TEXT) {
                this.type = TokenType.TEXT;
            } else if (required == TokenType.WORD) {
                ender1 = 32;
                ender2 = 13;
                this.type = TokenType.WORD;
            } else {
                ender1 = 58;
                ender2 = 58;
                this.type = TokenType.KEY;
            }
            this.start = cur;
            this.end = cur;
            while (++cur < len && serialized[cur] != ender1 && serialized[cur] != ender2) {
                this.end = cur;
            }
            if (cur >= len) {
                throw new IllegalArgumentException("Invalid header composition");
            }
            if (serialized[cur] == 13) {
                this.mustBeCrlf(len, cur);
            }
            this.hasValue = true;
        }
    }

    private void mustBeCrlf(int len, int cur) {
        if (cur + 1 >= len || this.serialized[cur + 1] != 10) {
            throw new IllegalArgumentException("Invalid header composition");
        }
    }

    public void mustBe(TokenType expected) {
        if (this.type != expected) {
            throw new IllegalArgumentException("Invalid header composition");
        }
    }

    public boolean isType(TokenType expected) {
        return this.type == expected;
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    public String getValue() {
        return this.hasValue ? new String(this.serialized, this.start, this.end - this.start + 1, StandardCharsets.US_ASCII).trim() : "";
    }

    public boolean samePoint(Token token) {
        return this.start == token.start && this.end == token.end && this.type == token.type;
    }
}

