/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class ByteArrayBuilder {
    public static final int DEFAULT_ASCII_ALLOCATION = 32;
    public static final int DEFAULT_OTHER_ALLOCATION = 64;
    public static final byte[] NULL = "null".getBytes(StandardCharsets.US_ASCII);
    private final Charset defaultCharset;
    private ByteBuffer buffer;
    private int allocationSize;

    public ByteArrayBuilder() {
        this(32, 32, StandardCharsets.US_ASCII);
    }

    public ByteArrayBuilder(int initialSize) {
        this(initialSize, 32, StandardCharsets.US_ASCII);
    }

    public ByteArrayBuilder(byte[] bytes) {
        this.allocationSize = Math.max(32, bytes.length);
        this.buffer = ByteBuffer.allocate(bytes.length);
        this.defaultCharset = StandardCharsets.US_ASCII;
        this.buffer.put(bytes, 0, bytes.length);
    }

    public ByteArrayBuilder(Charset defaultCharset) {
        this(-1, -1, defaultCharset);
    }

    public ByteArrayBuilder(int initialSize, Charset defaultCharset) {
        this(initialSize, -1, defaultCharset);
    }

    public ByteArrayBuilder(int initialSize, int allocationSize, Charset defaultCharset) {
        int n = allocationSize > 0 ? allocationSize : (this.allocationSize = defaultCharset == StandardCharsets.US_ASCII ? 32 : 64);
        int bytesNeeeded = initialSize > 0 ? initialSize : (defaultCharset == StandardCharsets.US_ASCII ? 32 : 64);
        this.buffer = ByteBuffer.allocate(bytesNeeeded);
        this.defaultCharset = defaultCharset;
    }

    public int length() {
        return this.buffer.position();
    }

    public boolean equals(byte[] bytes) {
        if (bytes == null || this.buffer.position() != bytes.length) {
            return false;
        }
        byte[] hb = this.buffer.array();
        for (int x = 0; x < bytes.length; ++x) {
            if (hb[x] == bytes[x]) continue;
            return false;
        }
        return true;
    }

    public int copyTo(byte[] dest, int destPos) {
        int len = this.length();
        byte[] hb = this.buffer.array();
        System.arraycopy(hb, 0, dest, destPos, len);
        return len;
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.buffer.array(), this.buffer.position());
    }

    public byte[] internalArray() {
        return this.buffer.array();
    }

    protected int computeAmountToAllocate(int currentPosition, int bytesNeeded) {
        return (currentPosition + bytesNeeded + this.allocationSize) / this.allocationSize * this.allocationSize;
    }

    public ByteArrayBuilder ensureCapacity(int bytesNeeded) {
        int bytesAvailable = this.buffer.capacity() - this.buffer.position();
        if (bytesAvailable < bytesNeeded) {
            ByteBuffer newBuffer = ByteBuffer.allocate(this.computeAmountToAllocate(this.buffer.position(), bytesNeeded));
            newBuffer.put(this.buffer.array(), 0, this.buffer.position());
            this.buffer = newBuffer;
        }
        return this;
    }

    public ByteArrayBuilder clear() {
        this.buffer.clear();
        return this;
    }

    public ByteArrayBuilder setAllocationSize(int allocationSize) {
        this.allocationSize = allocationSize;
        return this;
    }

    public ByteArrayBuilder append(int i) {
        this.append(Integer.toString(i).getBytes(StandardCharsets.US_ASCII));
        return this;
    }

    public ByteArrayBuilder append(String src) {
        return this.append(src, this.defaultCharset);
    }

    public ByteArrayBuilder append(String src, Charset charset) {
        return src == null ? this.append(NULL, 0, 4) : this.append(src.getBytes(charset));
    }

    public ByteArrayBuilder append(CharBuffer src) {
        return this.append(src, this.defaultCharset);
    }

    public ByteArrayBuilder append(CharBuffer src, Charset charset) {
        if (src == null) {
            this.append(NULL, 0, 4);
        } else {
            this.append(src.toString().getBytes(charset));
        }
        return this;
    }

    public ByteArrayBuilder append(byte b) {
        this.ensureCapacity(1);
        this.buffer.put(b);
        return this;
    }

    public ByteArrayBuilder append(byte[] src) {
        if (src.length > 0) {
            this.ensureCapacity(src.length);
            this.buffer.put(src, 0, src.length);
        }
        return this;
    }

    public ByteArrayBuilder append(byte[] src, int len) {
        if (len > 0) {
            this.ensureCapacity(len);
            this.buffer.put(src, 0, len);
        }
        return this;
    }

    public ByteArrayBuilder append(byte[] src, int offset, int len) {
        if (len > 0) {
            this.ensureCapacity(len);
            this.buffer.put(src, offset, len);
        }
        return this;
    }

    public ByteArrayBuilder append(ByteArrayBuilder bab) {
        if (bab != null && bab.length() > 0) {
            this.append(bab.buffer.array(), 0, bab.length());
        }
        return this;
    }

    public String toString() {
        return new String(this.buffer.array(), 0, this.buffer.position(), this.defaultCharset);
    }
}

