/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.PullSubscribeOptions;
import io.nats.client.PushSubscribeOptions;
import io.nats.client.api.AckPolicy;
import io.nats.client.api.DeliverPolicy;
import io.nats.client.api.ReplayPolicy;
import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.Validator;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;

public class ConsumerConfiguration
implements JsonSerializable {
    public static final DeliverPolicy DEFAULT_DELIVER_POLICY = DeliverPolicy.All;
    public static final AckPolicy DEFAULT_ACK_POLICY = AckPolicy.Explicit;
    public static final ReplayPolicy DEFAULT_REPLAY_POLICY = ReplayPolicy.Instant;
    public static final Duration MIN_IDLE_HEARTBEAT = Duration.ofMillis(100L);
    protected final DeliverPolicy deliverPolicy;
    protected final AckPolicy ackPolicy;
    protected final ReplayPolicy replayPolicy;
    protected final String description;
    protected final String durable;
    protected final String deliverSubject;
    protected final String deliverGroup;
    protected final String filterSubject;
    protected final String sampleFrequency;
    protected final ZonedDateTime startTime;
    protected final Duration ackWait;
    protected final Duration idleHeartbeat;
    protected final Duration maxExpires;
    protected final Duration inactiveThreshold;
    protected final Long startSeq;
    protected final Long maxDeliver;
    protected final Long rateLimit;
    protected final Long maxAckPending;
    protected final Long maxPullWaiting;
    protected final Long maxBatch;
    protected final Boolean flowControl;
    protected final Boolean headersOnly;
    protected final List<Duration> backoff;

    protected ConsumerConfiguration(ConsumerConfiguration cc) {
        this.deliverPolicy = cc.deliverPolicy;
        this.ackPolicy = cc.ackPolicy;
        this.replayPolicy = cc.replayPolicy;
        this.description = cc.description;
        this.durable = cc.durable;
        this.deliverSubject = cc.deliverSubject;
        this.deliverGroup = cc.deliverGroup;
        this.filterSubject = cc.filterSubject;
        this.sampleFrequency = cc.sampleFrequency;
        this.startTime = cc.startTime;
        this.ackWait = cc.ackWait;
        this.idleHeartbeat = cc.idleHeartbeat;
        this.maxExpires = cc.maxExpires;
        this.inactiveThreshold = cc.inactiveThreshold;
        this.startSeq = cc.startSeq;
        this.maxDeliver = cc.maxDeliver;
        this.rateLimit = cc.rateLimit;
        this.maxAckPending = cc.maxAckPending;
        this.maxPullWaiting = cc.maxPullWaiting;
        this.maxBatch = cc.maxBatch;
        this.flowControl = cc.flowControl;
        this.headersOnly = cc.headersOnly;
        this.backoff = new ArrayList<Duration>(cc.backoff);
    }

    ConsumerConfiguration(String json) {
        Matcher m = ApiConstants.DELIVER_POLICY_RE.matcher(json);
        this.deliverPolicy = m.find() ? DeliverPolicy.get(m.group(1)) : null;
        m = ApiConstants.ACK_POLICY_RE.matcher(json);
        this.ackPolicy = m.find() ? AckPolicy.get(m.group(1)) : null;
        m = ApiConstants.REPLAY_POLICY_RE.matcher(json);
        this.replayPolicy = m.find() ? ReplayPolicy.get(m.group(1)) : null;
        this.description = JsonUtils.readString(json, ApiConstants.DESCRIPTION_RE);
        this.durable = JsonUtils.readString(json, ApiConstants.DURABLE_NAME_RE);
        this.deliverSubject = JsonUtils.readString(json, ApiConstants.DELIVER_SUBJECT_RE);
        this.deliverGroup = JsonUtils.readString(json, ApiConstants.DELIVER_GROUP_RE);
        this.filterSubject = JsonUtils.readString(json, ApiConstants.FILTER_SUBJECT_RE);
        this.sampleFrequency = JsonUtils.readString(json, ApiConstants.SAMPLE_FREQ_RE);
        this.startTime = JsonUtils.readDate(json, ApiConstants.OPT_START_TIME_RE);
        this.ackWait = JsonUtils.readNanos(json, ApiConstants.ACK_WAIT_RE);
        this.idleHeartbeat = JsonUtils.readNanos(json, ApiConstants.IDLE_HEARTBEAT_RE);
        this.maxExpires = JsonUtils.readNanos(json, ApiConstants.MAX_EXPIRES_RE);
        this.inactiveThreshold = JsonUtils.readNanos(json, ApiConstants.INACTIVE_THRESHOLD_RE);
        this.startSeq = JsonUtils.readLong(json, ApiConstants.OPT_START_SEQ_RE);
        this.maxDeliver = JsonUtils.readLong(json, ApiConstants.MAX_DELIVER_RE);
        this.rateLimit = JsonUtils.readLong(json, ApiConstants.RATE_LIMIT_BPS_RE);
        this.maxAckPending = JsonUtils.readLong(json, ApiConstants.MAX_ACK_PENDING_RE);
        this.maxPullWaiting = JsonUtils.readLong(json, ApiConstants.MAX_WAITING_RE);
        this.maxBatch = JsonUtils.readLong(json, ApiConstants.MAX_BATCH_RE);
        this.flowControl = JsonUtils.readBoolean(json, ApiConstants.FLOW_CONTROL_RE, null);
        this.headersOnly = JsonUtils.readBoolean(json, ApiConstants.HEADERS_ONLY_RE, null);
        this.backoff = JsonUtils.getDurationList("backoff", json);
    }

    private ConsumerConfiguration(Builder b) {
        this.deliverPolicy = b.deliverPolicy;
        this.ackPolicy = b.ackPolicy;
        this.replayPolicy = b.replayPolicy;
        this.description = b.description;
        this.durable = b.durable;
        this.startTime = b.startTime;
        this.ackWait = b.ackWait;
        this.filterSubject = b.filterSubject;
        this.sampleFrequency = b.sampleFrequency;
        this.deliverSubject = b.deliverSubject;
        this.deliverGroup = b.deliverGroup;
        this.idleHeartbeat = b.idleHeartbeat;
        this.maxExpires = b.maxExpires;
        this.inactiveThreshold = b.inactiveThreshold;
        this.startSeq = b.startSeq;
        this.maxDeliver = b.maxDeliver;
        this.rateLimit = b.rateLimit;
        this.maxAckPending = b.maxAckPending;
        this.maxPullWaiting = b.maxPullWaiting;
        this.maxBatch = b.maxBatch;
        this.flowControl = b.flowControl;
        this.headersOnly = b.headersOnly;
        this.backoff = b.backoff;
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "description", this.description);
        JsonUtils.addField(sb, "durable_name", this.durable);
        JsonUtils.addField(sb, "deliver_subject", this.deliverSubject);
        JsonUtils.addField(sb, "deliver_group", this.deliverGroup);
        JsonUtils.addField(sb, "deliver_policy", ConsumerConfiguration.GetOrDefault(this.deliverPolicy).toString());
        JsonUtils.addFieldWhenGtZero(sb, "opt_start_seq", this.startSeq);
        JsonUtils.addField(sb, "opt_start_time", this.startTime);
        JsonUtils.addField(sb, "ack_policy", ConsumerConfiguration.GetOrDefault(this.ackPolicy).toString());
        JsonUtils.addFieldAsNanos(sb, "ack_wait", this.ackWait);
        JsonUtils.addFieldWhenGtZero(sb, "max_deliver", this.maxDeliver);
        JsonUtils.addField(sb, "max_ack_pending", this.maxAckPending);
        JsonUtils.addField(sb, "filter_subject", this.filterSubject);
        JsonUtils.addField(sb, "replay_policy", ConsumerConfiguration.GetOrDefault(this.replayPolicy).toString());
        JsonUtils.addField(sb, "sample_freq", this.sampleFrequency);
        JsonUtils.addFieldWhenGtZero(sb, "rate_limit_bps", this.rateLimit);
        JsonUtils.addFieldAsNanos(sb, "idle_heartbeat", this.idleHeartbeat);
        JsonUtils.addFldWhenTrue(sb, "flow_control", this.flowControl);
        JsonUtils.addField(sb, "max_waiting", this.maxPullWaiting);
        JsonUtils.addFldWhenTrue(sb, "headers_only", this.headersOnly);
        JsonUtils.addField(sb, "max_batch", this.maxBatch);
        JsonUtils.addFieldAsNanos(sb, "max_expires", this.maxExpires);
        JsonUtils.addFieldAsNanos(sb, "inactive_threshold", this.inactiveThreshold);
        JsonUtils.addDurations(sb, "backoff", this.backoff);
        return JsonUtils.endJson(sb).toString();
    }

    public String getDescription() {
        return this.description;
    }

    public String getDurable() {
        return this.durable;
    }

    public String getDeliverSubject() {
        return this.deliverSubject;
    }

    public String getDeliverGroup() {
        return this.deliverGroup;
    }

    public DeliverPolicy getDeliverPolicy() {
        return ConsumerConfiguration.GetOrDefault(this.deliverPolicy);
    }

    public long getStartSequence() {
        return UlongChangeHelper.START_SEQ.getOrUnset(this.startSeq);
    }

    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    public AckPolicy getAckPolicy() {
        return ConsumerConfiguration.GetOrDefault(this.ackPolicy);
    }

    public Duration getAckWait() {
        return this.ackWait;
    }

    public long getMaxDeliver() {
        return LongChangeHelper.MAX_DELIVER.getOrUnset(this.maxDeliver);
    }

    public String getFilterSubject() {
        return this.filterSubject;
    }

    public ReplayPolicy getReplayPolicy() {
        return ConsumerConfiguration.GetOrDefault(this.replayPolicy);
    }

    public long getRateLimit() {
        return UlongChangeHelper.RATE_LIMIT.getOrUnset(this.rateLimit);
    }

    public long getMaxAckPending() {
        return LongChangeHelper.MAX_ACK_PENDING.getOrUnset(this.maxAckPending);
    }

    public String getSampleFrequency() {
        return this.sampleFrequency;
    }

    public Duration getIdleHeartbeat() {
        return this.idleHeartbeat;
    }

    public boolean isFlowControl() {
        return this.flowControl != null && this.flowControl != false;
    }

    public long getMaxPullWaiting() {
        return LongChangeHelper.MAX_PULL_WAITING.getOrUnset(this.maxPullWaiting);
    }

    public boolean isHeadersOnly() {
        return this.headersOnly != null && this.headersOnly != false;
    }

    public Long getMaxBatch() {
        return LongChangeHelper.MAX_BATCH.getOrUnset(this.maxBatch);
    }

    public Duration getMaxExpires() {
        return this.maxExpires;
    }

    public Duration getInactiveThreshold() {
        return this.inactiveThreshold;
    }

    public List<Duration> getBackoff() {
        return this.backoff;
    }

    public boolean deliverPolicyWasSet() {
        return this.deliverPolicy != null;
    }

    public boolean ackPolicyWasSet() {
        return this.ackPolicy != null;
    }

    public boolean replayPolicyWasSet() {
        return this.replayPolicy != null;
    }

    public boolean startSeqWasSet() {
        return this.startSeq != null;
    }

    public boolean maxDeliverWasSet() {
        return this.maxDeliver != null;
    }

    public boolean rateLimitWasSet() {
        return this.rateLimit != null;
    }

    public boolean maxAckPendingWasSet() {
        return this.maxAckPending != null;
    }

    public boolean maxPullWaitingWasSet() {
        return this.maxPullWaiting != null;
    }

    public boolean maxBatchWasSet() {
        return this.maxBatch != null;
    }

    public boolean flowControlWasSet() {
        return this.flowControl != null;
    }

    public boolean headersOnlyWasSet() {
        return this.headersOnly != null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ConsumerConfiguration cc) {
        return cc == null ? new Builder() : new Builder(cc);
    }

    public String toString() {
        return "ConsumerConfiguration{description='" + this.description + '\'' + ", durable='" + this.durable + '\'' + ", deliverPolicy=" + (Object)((Object)this.deliverPolicy) + ", deliverSubject='" + this.deliverSubject + '\'' + ", deliverGroup='" + this.deliverGroup + '\'' + ", startSeq=" + this.startSeq + ", startTime=" + this.startTime + ", ackPolicy=" + (Object)((Object)this.ackPolicy) + ", ackWait=" + this.ackWait + ", maxDeliver=" + this.maxDeliver + ", filterSubject='" + this.filterSubject + '\'' + ", replayPolicy=" + (Object)((Object)this.replayPolicy) + ", sampleFrequency='" + this.sampleFrequency + '\'' + ", rateLimit=" + this.rateLimit + ", maxAckPending=" + this.maxAckPending + ", idleHeartbeat=" + this.idleHeartbeat + ", flowControl=" + this.flowControl + ", maxPullWaiting=" + this.maxPullWaiting + ", maxBatch=" + this.maxBatch + ", maxExpires=" + this.maxExpires + ", inactiveThreshold=" + this.inactiveThreshold + ", backoff=" + this.backoff + '}';
    }

    private static DeliverPolicy GetOrDefault(DeliverPolicy p) {
        return p == null ? DEFAULT_DELIVER_POLICY : p;
    }

    private static AckPolicy GetOrDefault(AckPolicy p) {
        return p == null ? DEFAULT_ACK_POLICY : p;
    }

    private static ReplayPolicy GetOrDefault(ReplayPolicy p) {
        return p == null ? DEFAULT_REPLAY_POLICY : p;
    }

    public static enum DurationChangeHelper {
        ACK_WAIT;

        public final Duration Min = Duration.ofNanos(1L);
        public final Duration Unset = Duration.ZERO;
        public final long MinNanos;

        private DurationChangeHelper() {
            this.MinNanos = 1L;
        }

        public Duration getOrUnset(Duration val) {
            return val == null ? this.Unset : val;
        }

        public boolean wouldBeChange(Duration user, Duration server) {
            return user != null && !user.equals(this.getOrUnset(server));
        }

        public Duration forBuilder(Duration proposed) {
            return proposed == null || proposed.toNanos() < this.MinNanos ? this.Unset : proposed;
        }
    }

    public static enum UlongChangeHelper {
        START_SEQ(1L, 0L),
        RATE_LIMIT(1L, 0L);

        public final long Min;
        public final long Unset;

        private UlongChangeHelper(long min, long unset) {
            this.Min = min;
            this.Unset = unset;
        }

        public long getOrUnset(Long val) {
            return val == null ? this.Unset : val;
        }

        public boolean wouldBeChange(Long user, Long server) {
            return user != null && !user.equals(this.getOrUnset(server));
        }

        public Long forBuilder(Long proposed) {
            return proposed == null || proposed < this.Min ? this.Unset : proposed;
        }
    }

    public static enum LongChangeHelper {
        MAX_DELIVER(1L, -1L),
        MAX_ACK_PENDING(0L, -1L),
        MAX_PULL_WAITING(0L, -1L),
        MAX_BATCH(0L, -1L);

        public final long Min;
        public final long Unset;

        private LongChangeHelper(long min, long unset) {
            this.Min = min;
            this.Unset = unset;
        }

        public long getOrUnset(Long val) {
            return val == null ? this.Unset : val;
        }

        public boolean wouldBeChange(Long user, Long server) {
            return user != null && !user.equals(this.getOrUnset(server));
        }

        public Long forBuilder(Long proposed) {
            return proposed == null || proposed < this.Min ? this.Unset : proposed;
        }
    }

    public static class Builder {
        private DeliverPolicy deliverPolicy;
        private AckPolicy ackPolicy;
        private ReplayPolicy replayPolicy;
        private String description;
        private String durable;
        private String deliverSubject;
        private String deliverGroup;
        private String filterSubject;
        private String sampleFrequency;
        private ZonedDateTime startTime;
        private Duration ackWait;
        private Duration idleHeartbeat;
        private Duration maxExpires;
        private Duration inactiveThreshold;
        private Long startSeq;
        private Long maxDeliver;
        private Long rateLimit;
        private Long maxAckPending;
        private Long maxPullWaiting;
        private Long maxBatch;
        private Boolean flowControl;
        private Boolean headersOnly;
        private List<Duration> backoff = new ArrayList<Duration>();

        public Builder() {
        }

        public Builder(ConsumerConfiguration cc) {
            if (cc != null) {
                this.deliverPolicy = cc.deliverPolicy;
                this.ackPolicy = cc.ackPolicy;
                this.replayPolicy = cc.replayPolicy;
                this.description = cc.description;
                this.durable = cc.durable;
                this.deliverSubject = cc.deliverSubject;
                this.deliverGroup = cc.deliverGroup;
                this.filterSubject = cc.filterSubject;
                this.sampleFrequency = cc.sampleFrequency;
                this.startTime = cc.startTime;
                this.ackWait = cc.ackWait;
                this.idleHeartbeat = cc.idleHeartbeat;
                this.maxExpires = cc.maxExpires;
                this.inactiveThreshold = cc.inactiveThreshold;
                this.startSeq = cc.startSeq;
                this.maxDeliver = cc.maxDeliver;
                this.rateLimit = cc.rateLimit;
                this.maxAckPending = cc.maxAckPending;
                this.maxPullWaiting = cc.maxPullWaiting;
                this.maxBatch = cc.maxBatch;
                this.flowControl = cc.flowControl;
                this.headersOnly = cc.headersOnly;
                this.backoff = new ArrayList<Duration>(cc.backoff);
            }
        }

        public Builder description(String description) {
            this.description = Validator.emptyAsNull(description);
            return this;
        }

        public Builder durable(String durable) {
            this.durable = Validator.emptyAsNull(durable);
            return this;
        }

        public Builder deliverPolicy(DeliverPolicy policy) {
            this.deliverPolicy = policy;
            return this;
        }

        public Builder deliverSubject(String subject) {
            this.deliverSubject = Validator.emptyAsNull(subject);
            return this;
        }

        public Builder deliverGroup(String group) {
            this.deliverGroup = Validator.emptyAsNull(group);
            return this;
        }

        public Builder startSequence(Long sequence) {
            this.startSeq = UlongChangeHelper.START_SEQ.forBuilder(sequence);
            return this;
        }

        public Builder startSequence(long sequence) {
            this.startSeq = UlongChangeHelper.START_SEQ.forBuilder(sequence);
            return this;
        }

        public Builder startTime(ZonedDateTime startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder ackPolicy(AckPolicy policy) {
            this.ackPolicy = policy;
            return this;
        }

        public Builder ackWait(Duration timeout) {
            this.ackWait = DurationChangeHelper.ACK_WAIT.forBuilder(timeout);
            return this;
        }

        public Builder ackWait(long timeoutMillis) {
            this.ackWait = DurationChangeHelper.ACK_WAIT.forBuilder(Duration.ofMillis(timeoutMillis));
            return this;
        }

        public Builder maxDeliver(Long maxDeliver) {
            this.maxDeliver = LongChangeHelper.MAX_DELIVER.forBuilder(maxDeliver);
            return this;
        }

        public Builder maxDeliver(long maxDeliver) {
            this.maxDeliver = LongChangeHelper.MAX_DELIVER.forBuilder(maxDeliver);
            return this;
        }

        public Builder filterSubject(String filterSubject) {
            this.filterSubject = Validator.emptyAsNull(filterSubject);
            return this;
        }

        public Builder replayPolicy(ReplayPolicy policy) {
            this.replayPolicy = policy;
            return this;
        }

        public Builder sampleFrequency(String frequency) {
            this.sampleFrequency = Validator.emptyAsNull(frequency);
            return this;
        }

        public Builder rateLimit(Long bitsPerSecond) {
            this.rateLimit = UlongChangeHelper.RATE_LIMIT.forBuilder(bitsPerSecond);
            return this;
        }

        public Builder rateLimit(long bitsPerSecond) {
            this.rateLimit = UlongChangeHelper.RATE_LIMIT.forBuilder(bitsPerSecond);
            return this;
        }

        public Builder maxAckPending(Long maxAckPending) {
            this.maxAckPending = LongChangeHelper.MAX_ACK_PENDING.forBuilder(maxAckPending);
            return this;
        }

        public Builder maxAckPending(long maxAckPending) {
            this.maxAckPending = LongChangeHelper.MAX_ACK_PENDING.forBuilder(maxAckPending);
            return this;
        }

        public Builder idleHeartbeat(Duration idleHeartbeat) {
            this.idleHeartbeat = Validator.validateDurationNotRequiredNotLessThanMin(idleHeartbeat, MIN_IDLE_HEARTBEAT);
            return this;
        }

        public Builder idleHeartbeat(long idleHeartbeatMillis) {
            this.idleHeartbeat = Validator.validateDurationNotRequiredNotLessThanMin(idleHeartbeatMillis, MIN_IDLE_HEARTBEAT);
            return this;
        }

        public Builder flowControl(Duration idleHeartbeat) {
            this.flowControl = true;
            return this.idleHeartbeat(idleHeartbeat);
        }

        public Builder flowControl(long idleHeartbeatMillis) {
            this.flowControl = true;
            return this.idleHeartbeat(idleHeartbeatMillis);
        }

        public Builder maxExpires(Duration maxExpires) {
            this.maxExpires = Validator.validateDurationNotRequiredGtOrEqZero(maxExpires, null);
            return this;
        }

        public Builder maxExpires(long maxExpires) {
            this.maxExpires = Validator.validateDurationNotRequiredGtOrEqZero(maxExpires);
            return this;
        }

        public Builder inactiveThreshold(Duration inactiveThreshold) {
            this.inactiveThreshold = Validator.validateDurationNotRequiredGtOrEqZero(inactiveThreshold, null);
            return this;
        }

        public Builder inactiveThreshold(long inactiveThreshold) {
            this.inactiveThreshold = Validator.validateDurationNotRequiredGtOrEqZero(inactiveThreshold);
            return this;
        }

        public Builder maxPullWaiting(Long maxPullWaiting) {
            this.maxPullWaiting = LongChangeHelper.MAX_PULL_WAITING.forBuilder(maxPullWaiting);
            return this;
        }

        public Builder maxPullWaiting(long maxPullWaiting) {
            this.maxPullWaiting = LongChangeHelper.MAX_PULL_WAITING.forBuilder(maxPullWaiting);
            return this;
        }

        public Builder maxBatch(Long maxBatch) {
            this.maxBatch = LongChangeHelper.MAX_BATCH.forBuilder(maxBatch);
            return this;
        }

        public Builder maxBatch(long maxBatch) {
            this.maxBatch = LongChangeHelper.MAX_BATCH.forBuilder(maxBatch);
            return this;
        }

        public Builder headersOnly(Boolean headersOnly) {
            this.headersOnly = headersOnly;
            return this;
        }

        public Builder backoff(Duration ... backoffs) {
            this.backoff.clear();
            if (backoffs != null) {
                for (Duration d : backoffs) {
                    if (d == null) continue;
                    this.backoff.add(d);
                }
            }
            return this;
        }

        public Builder backoff(long ... backoffsMillis) {
            this.backoff.clear();
            if (backoffsMillis != null) {
                for (long ms : backoffsMillis) {
                    this.backoff.add(Duration.ofMillis(ms));
                }
            }
            return this;
        }

        public ConsumerConfiguration build() {
            return new ConsumerConfiguration(this);
        }

        public PushSubscribeOptions buildPushSubscribeOptions() {
            return ((PushSubscribeOptions.Builder)PushSubscribeOptions.builder().configuration(this.build())).build();
        }

        public PullSubscribeOptions buildPullSubscribeOptions() {
            return ((PullSubscribeOptions.Builder)PullSubscribeOptions.builder().configuration(this.build())).build();
        }
    }
}

