/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStreamStatusException;
import io.nats.client.Message;
import io.nats.client.impl.AutoStatusManager;
import io.nats.client.impl.NatsJetStreamSubscription;
import java.util.Arrays;
import java.util.List;

class PullAutoStatusManager
implements AutoStatusManager {
    private static final List<Integer> PULL_KNOWN_STATUS_CODES = Arrays.asList(404, 408);
    private NatsJetStreamSubscription sub;

    PullAutoStatusManager() {
    }

    @Override
    public void setSub(NatsJetStreamSubscription sub) {
        this.sub = sub;
    }

    @Override
    public boolean manage(Message msg) {
        if (!msg.isStatusMessage()) {
            return false;
        }
        if (!PULL_KNOWN_STATUS_CODES.contains(msg.getStatus().getCode())) {
            throw new JetStreamStatusException(this.sub, msg.getStatus());
        }
        return true;
    }
}

