/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.api.ConsumerInfo;
import io.nats.client.impl.AutoStatusManager;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsDispatcher;
import io.nats.client.impl.NatsJetStream;
import io.nats.client.impl.NatsJetStreamPullSubscription;
import io.nats.client.impl.NatsMessage;
import io.nats.client.impl.NatsSubscription;
import io.nats.client.support.NatsJetStreamConstants;
import java.io.IOException;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;

public class NatsJetStreamSubscription
extends NatsSubscription
implements JetStreamSubscription,
NatsJetStreamConstants {
    public static final String SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL = "Subscription type does not support pull.";
    protected final NatsJetStream js;
    protected final String stream;
    protected final String consumerName;
    protected final String deliver;
    protected final AutoStatusManager asm;

    static NatsJetStreamSubscription getInstance(String sid, String subject, String queueName, NatsConnection connection, NatsDispatcher dispatcher, AutoStatusManager asm, NatsJetStream js, boolean pullMode, String stream, String consumer, String deliver) {
        if (pullMode) {
            return new NatsJetStreamPullSubscription(sid, subject, connection, asm, js, stream, consumer);
        }
        return new NatsJetStreamSubscription(sid, subject, queueName, connection, dispatcher, asm, js, stream, consumer, deliver);
    }

    protected NatsJetStreamSubscription(String sid, String subject, String queueName, NatsConnection connection, NatsDispatcher dispatcher, AutoStatusManager asm, NatsJetStream js, String stream, String consumer, String deliver) {
        super(sid, subject, queueName, connection, dispatcher);
        this.asm = asm;
        this.js = js;
        this.stream = stream;
        this.consumerName = consumer;
        this.deliver = deliver;
    }

    String getConsumerName() {
        return this.consumerName;
    }

    String getStream() {
        return this.stream;
    }

    String getDeliverSubject() {
        return this.deliver;
    }

    boolean isPullMode() {
        return false;
    }

    AutoStatusManager getAsm() {
        return this.asm;
    }

    @Override
    void invalidate() {
        this.asm.shutdown();
        super.invalidate();
    }

    @Override
    public Message nextMessage(Duration timeout) throws InterruptedException, IllegalStateException {
        if (timeout == null || timeout.toMillis() <= 0L) {
            return this.nextMsgNullOrLteZero(timeout);
        }
        return this.nextMessageWithEndTime(System.currentTimeMillis() + timeout.toMillis());
    }

    @Override
    public Message nextMessage(long timeoutMillis) throws InterruptedException, IllegalStateException {
        if (timeoutMillis <= 0L) {
            return this.nextMsgNullOrLteZero(Duration.ZERO);
        }
        return this.nextMessageWithEndTime(System.currentTimeMillis() + timeoutMillis);
    }

    protected Message nextMsgNullOrLteZero(Duration timeout) throws InterruptedException {
        NatsMessage msg = this.nextMessageInternal(timeout);
        while (msg != null && this.asm.manage(msg)) {
            msg = this.nextMessageInternal(timeout);
        }
        return msg;
    }

    protected Message nextMessageWithEndTime(long endTime) throws InterruptedException {
        long millis = endTime - System.currentTimeMillis();
        while (millis > 0L) {
            NatsMessage msg = this.nextMessageInternal(Duration.ofMillis(millis));
            if (msg != null && !this.asm.manage(msg)) {
                return msg;
            }
            millis = endTime - System.currentTimeMillis();
        }
        return null;
    }

    @Override
    public void pull(int batchSize) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public void pullNoWait(int batchSize) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public void pullExpiresIn(int batchSize, Duration expiresIn) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public void pullExpiresIn(int batchSize, long expiresInMillis) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public List<Message> fetch(int batchSize, long maxWaitMillis) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public List<Message> fetch(int batchSize, Duration maxWait) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public Iterator<Message> iterate(int batchSize, Duration maxWait) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public Iterator<Message> iterate(int batchSize, long maxWaitMillis) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public ConsumerInfo getConsumerInfo() throws IOException, JetStreamApiException {
        return this.js.lookupConsumerInfo(this.stream, this.consumerName);
    }

    public String toString() {
        return "NatsJetStreamSubscription{consumer='" + this.consumerName + '\'' + ", stream='" + this.stream + '\'' + ", deliver='" + this.deliver + '\'' + ", isPullMode=" + this.isPullMode() + '}';
    }
}

