/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.api.KvOperation;
import io.nats.client.impl.Headers;

public abstract class NatsKeyValueUtil {
    public static final String KV_STREAM_PREFIX = "KV_";
    public static final int KV_STREAM_PREFIX_LEN = "KV_".length();
    public static final String KV_SUBJECT_PREFIX = "$KV.";
    public static final String KV_SUBJECT_SUFFIX = ".>";
    public static final String KV_OPERATION_HEADER_KEY = "KV-Operation";

    public static String streamName(String bucketName) {
        return KV_STREAM_PREFIX + bucketName;
    }

    public static String extractBucketName(String streamName) {
        return streamName.substring(KV_STREAM_PREFIX_LEN);
    }

    public static String streamSubject(String bucketName) {
        return KV_SUBJECT_PREFIX + bucketName + KV_SUBJECT_SUFFIX;
    }

    public static String keySubject(String bucketName, String key) {
        return KV_SUBJECT_PREFIX + bucketName + "." + key;
    }

    public static Headers addDeleteHeader(Headers h) {
        return h.put(KV_OPERATION_HEADER_KEY, KvOperation.DEL.name());
    }

    public static String getHeader(Headers h) {
        return h == null ? null : h.getFirst(KV_OPERATION_HEADER_KEY);
    }
}

