/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.BucketConfiguration;
import io.nats.client.api.StreamInfo;
import io.nats.client.support.JsonUtils;
import java.time.ZonedDateTime;

public class BucketInfo {
    private final StreamInfo streamInfo;
    private final BucketConfiguration config;

    public BucketInfo(StreamInfo si) {
        this.streamInfo = si;
        this.config = new BucketConfiguration(this.streamInfo.getConfiguration());
    }

    public BucketConfiguration getConfiguration() {
        return this.config;
    }

    public long getRecordCount() {
        return this.streamInfo.getStreamState().getMsgCount();
    }

    public long getByteCount() {
        return this.streamInfo.getStreamState().getByteCount();
    }

    public long getLastSequence() {
        return this.streamInfo.getStreamState().getLastSequence();
    }

    public ZonedDateTime getCreateTime() {
        return this.streamInfo.getCreateTime();
    }

    public String toString() {
        return "BucketInfo{created=" + this.getCreateTime() + "recordCount=" + this.getRecordCount() + "byteCount=" + this.getByteCount() + "lastSequence=" + this.getLastSequence() + ", " + JsonUtils.objectString("config", this.config) + '}';
    }
}

