/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.support.Validator;

public abstract class SubscribeOptions {
    protected final String stream;
    protected final boolean isBind;
    protected final ConsumerConfiguration consumerConfig;

    protected SubscribeOptions(String stream, String durable, String deliverSubject, boolean isBind, boolean pull, ConsumerConfiguration cc) {
        this.stream = Validator.validateStreamName(stream, isBind);
        durable = durable == null && cc != null ? Validator.emptyAsNull(cc.getDurable()) : durable;
        durable = Validator.validateDurable(durable, pull || isBind);
        this.consumerConfig = ConsumerConfiguration.builder(cc).durable(durable).deliverSubject(deliverSubject).build();
        this.isBind = isBind;
    }

    public String getStream() {
        return this.stream;
    }

    public String getDurable() {
        return this.consumerConfig.getDurable();
    }

    public boolean isBind() {
        return this.isBind;
    }

    public ConsumerConfiguration getConsumerConfiguration() {
        return this.consumerConfig;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{stream='" + this.stream + '\'' + "bind=" + this.isBind + ", " + this.consumerConfig + '}';
    }

    protected static abstract class Builder<B, SO> {
        protected String stream;
        protected boolean isBind;
        protected String durable;
        protected ConsumerConfiguration consumerConfig;

        protected Builder() {
        }

        protected abstract B getThis();

        public B stream(String stream) {
            this.stream = Validator.emptyAsNull(stream);
            return this.getThis();
        }

        public B bind(boolean isBind) {
            this.isBind = isBind;
            return this.getThis();
        }

        public B durable(String durable) {
            this.durable = Validator.emptyAsNull(durable);
            return this.getThis();
        }

        public B configuration(ConsumerConfiguration configuration) {
            this.consumerConfig = configuration;
            return this.getThis();
        }

        public abstract SO build();
    }
}

