/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Options;
import io.nats.client.impl.DataPort;
import io.nats.client.impl.NatsConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SocketDataPort
implements DataPort {
    private NatsConnection connection;
    private String host;
    private int port;
    private Socket socket;
    private SSLSocket sslSocket;
    private InputStream in;
    private OutputStream out;

    @Override
    public void connect(String serverURI, NatsConnection conn, long timeoutNanos) throws IOException {
        try {
            this.connection = conn;
            Options options = this.connection.getOptions();
            long timeout = timeoutNanos / 1000000L;
            URI uri = options.createURIForServer(serverURI);
            this.host = uri.getHost();
            this.port = uri.getPort();
            this.socket = new Socket();
            this.socket.setTcpNoDelay(true);
            this.socket.setReceiveBufferSize(0x200000);
            this.socket.setSendBufferSize(0x200000);
            this.socket.connect(new InetSocketAddress(this.host, this.port), (int)timeout);
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void upgradeToSecure() throws IOException {
        Options options = this.connection.getOptions();
        SSLContext context = options.getSslContext();
        SSLSocketFactory factory = context.getSocketFactory();
        Duration timeout = options.getConnectionTimeout();
        this.sslSocket = (SSLSocket)factory.createSocket(this.socket, this.host, this.port, true);
        this.sslSocket.setUseClientMode(true);
        CompletableFuture waitForHandshake = new CompletableFuture();
        this.sslSocket.addHandshakeCompletedListener(evt -> waitForHandshake.complete(null));
        this.sslSocket.startHandshake();
        try {
            waitForHandshake.get(timeout.toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (Exception ex) {
            this.connection.handleCommunicationIssue(ex);
            return;
        }
        this.in = this.sslSocket.getInputStream();
        this.out = this.sslSocket.getOutputStream();
    }

    @Override
    public int read(byte[] dst, int off, int len) throws IOException {
        return this.in.read(dst, off, len);
    }

    @Override
    public void write(byte[] src, int toWrite) throws IOException {
        this.out.write(src, 0, toWrite);
    }

    @Override
    public void shutdownInput() throws IOException {
        if (this.sslSocket == null) {
            this.socket.shutdownInput();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.sslSocket != null) {
            this.sslSocket.close();
        } else {
            this.socket.close();
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }
}

