/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.PullSubscribeOptions;
import io.nats.client.SubscribeOptions;
import io.nats.client.api.ConsumerInfo;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsDispatcher;
import io.nats.client.impl.NatsJetStream;
import io.nats.client.impl.NatsSubscription;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.NatsJetStreamConstants;
import io.nats.client.support.Validator;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NatsJetStreamSubscription
extends NatsSubscription
implements JetStreamSubscription,
NatsJetStreamConstants {
    private NatsJetStream js;
    private String consumer;
    private String stream;
    private String deliver;
    private boolean isPullMode;
    private static final Duration SUBSEQUENT_WAITS = Duration.ofMillis(500L);

    NatsJetStreamSubscription(String sid, String subject, String queueName, NatsConnection connection, NatsDispatcher dispatcher) {
        super(sid, subject, queueName, connection, dispatcher);
    }

    void setupJetStream(NatsJetStream js, String consumer, String stream, String deliver, SubscribeOptions subscribeOptions) {
        this.js = js;
        this.consumer = consumer;
        this.stream = stream;
        this.deliver = deliver;
        this.isPullMode = subscribeOptions instanceof PullSubscribeOptions;
    }

    boolean isPullMode() {
        return this.isPullMode;
    }

    @Override
    public void pull(int batchSize) {
        this._pull(batchSize, false, null);
    }

    @Override
    public void pullNoWait(int batchSize) {
        this._pull(batchSize, true, null);
    }

    @Override
    public void pullExpiresIn(int batchSize, Duration expiresIn) {
        this._pull(batchSize, false, expiresIn);
    }

    private void _pull(int batchSize, boolean noWait, Duration expiresIn) {
        if (!this.isPullMode()) {
            throw new IllegalStateException("Subscription type does not support pull.");
        }
        int batch = Validator.validatePullBatchSize(batchSize);
        String publishSubject = this.js.prependPrefix(String.format("CONSUMER.MSG.NEXT.%s.%s", this.stream, this.consumer));
        this.connection.publish(publishSubject, this.getSubject(), this.getPullJson(batch, noWait, expiresIn, null));
        this.connection.lenientFlushBuffer();
    }

    byte[] getPullJson(int batch, boolean noWait, Duration expiresIn, String prefix) {
        StringBuilder sb = JsonUtils.beginJsonPrefixed(prefix);
        JsonUtils.addField(sb, "batch", batch);
        JsonUtils.addFldWhenTrue(sb, "no_wait", noWait);
        JsonUtils.addFieldAsNanos(sb, "expires", expiresIn);
        return JsonUtils.endJson(sb).toString().getBytes(StandardCharsets.US_ASCII);
    }

    @Override
    public ConsumerInfo getConsumerInfo() throws IOException, JetStreamApiException {
        return this.js.lookupConsumerInfo(this.stream, this.consumer);
    }

    @Override
    public List<Message> fetch(int batchSize, Duration maxWait) {
        ArrayList<Message> messages = new ArrayList<Message>(batchSize);
        try {
            this.pullNoWait(batchSize);
            this.read(batchSize, maxWait, messages);
            if (messages.size() == 0) {
                this.pullExpiresIn(batchSize, maxWait.minusMillis(10L));
                this.read(batchSize, maxWait, messages);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return messages;
    }

    private void read(int batchSize, Duration maxWait, List<Message> messages) throws InterruptedException {
        Message msg = this.nextMessage(maxWait);
        while (msg != null) {
            if (msg.isJetStream()) {
                messages.add(msg);
                if (messages.size() == batchSize) break;
            }
            msg = this.nextMessage(SUBSEQUENT_WAITS);
        }
    }

    @Override
    public Iterator<Message> iterate(final int batchSize, final Duration maxWait) {
        this.pullNoWait(batchSize);
        return new Iterator<Message>(){
            int received = 0;
            boolean finished = false;
            boolean stepDown = true;
            Duration wait = maxWait;
            Message msg = null;

            @Override
            public boolean hasNext() {
                while (!this.finished && this.msg == null) {
                    try {
                        this.msg = NatsJetStreamSubscription.this.nextMessage(this.wait);
                        this.wait = SUBSEQUENT_WAITS;
                        if (this.msg == null) {
                            if (this.received == 0 && this.stepDown) {
                                this.stepDown = false;
                                NatsJetStreamSubscription.this.pullExpiresIn(batchSize, maxWait.minusMillis(10L));
                                continue;
                            }
                            this.finished = true;
                            continue;
                        }
                        if (this.msg.isJetStream()) {
                            this.finished = ++this.received == batchSize;
                            continue;
                        }
                        this.msg = null;
                    }
                    catch (InterruptedException e) {
                        this.msg = null;
                        this.finished = true;
                        Thread.currentThread().interrupt();
                    }
                }
                return this.msg != null;
            }

            @Override
            public Message next() {
                Message next = this.msg;
                this.msg = null;
                return next;
            }
        };
    }

    public String toString() {
        return "NatsJetStreamSubscription{consumer='" + this.consumer + '\'' + ", stream='" + this.stream + '\'' + ", deliver='" + this.deliver + '\'' + ", isPullMode='" + this.isPullMode() + '}';
    }

    private static interface InternalBatchHandler {
        public boolean onMessage(Message var1) throws InterruptedException;
    }
}

