/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.runner.core.executor.dependency;

import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.common.Validable;
import io.mongock.runner.core.executor.dependency.DependencyContext;
import io.mongock.runner.core.executor.dependency.DependencyManager;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyManagerWithContext
extends DependencyManager
implements Validable {
    private static final Logger logger = LoggerFactory.getLogger(DependencyManagerWithContext.class);
    private DependencyContext context;

    public void setContext(DependencyContext context) {
        this.context = context;
    }

    public boolean isContextPresent() {
        return this.context != null;
    }

    public DependencyContext getDependencyContext() {
        return this.context;
    }

    @Override
    public Optional<Object> getDependency(Class type, boolean lockGuarded) {
        return this.getDependency(type, null, lockGuarded);
    }

    @Override
    public Optional<Object> getDependency(Class type, String name, boolean lockGuarded) {
        Optional<Object> dependencyFromParent = super.getDependency(type, name, lockGuarded);
        if (dependencyFromParent.isPresent()) {
            return dependencyFromParent;
        }
        if (this.context != null) {
            Optional<Object> dependencyFromContext;
            boolean byName = name != null && !name.isEmpty() && !"default_name_not_used".equals(name);
            Optional<Object> optional = dependencyFromContext = byName ? this.context.getBean(name) : this.context.getBean(type);
            if (dependencyFromContext.isPresent()) {
                return lockGuarded ? dependencyFromContext.map(instance -> this.lockGuardProxyFactory.getRawProxy(instance, type)) : dependencyFromContext;
            }
            logger.warn("Dependency not found: {}", (Object)(byName ? name : type.getSimpleName()));
            return Optional.empty();
        }
        return Optional.empty();
    }

    @Override
    public void runValidation() throws MongockException {
        if (this.context == null) {
            throw new MongockException("SpringContext not injected to SpringDependencyManager");
        }
    }
}

