/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.runner.core.event;

import io.mongock.runner.core.event.result.MigrationSuccessResult;
import java.util.function.Consumer;

public class EventPublisher {
    private final Runnable migrationStartedListener;
    private final Consumer<MigrationSuccessResult> migrationSuccessListener;
    private final Consumer<Exception> migrationFailedListener;

    public EventPublisher() {
        this(null, null, null);
    }

    public EventPublisher(Runnable migrationStartedListener, Consumer<MigrationSuccessResult> migrationSuccessListener, Consumer<Exception> migrationFailedListener) {
        this.migrationSuccessListener = migrationSuccessListener;
        this.migrationFailedListener = migrationFailedListener;
        this.migrationStartedListener = migrationStartedListener;
    }

    public void publishMigrationStarted() {
        if (this.migrationStartedListener != null) {
            this.migrationStartedListener.run();
        }
    }

    public void publishMigrationSuccessEvent(MigrationSuccessResult migrationResult) {
        if (this.migrationSuccessListener != null) {
            this.migrationSuccessListener.accept(migrationResult);
        }
    }

    public void publishMigrationFailedEvent(Exception ex) {
        if (this.migrationFailedListener != null) {
            this.migrationFailedListener.accept(ex);
        }
    }

    public Runnable getMigrationStartedListener() {
        return this.migrationStartedListener;
    }

    public Consumer<MigrationSuccessResult> getMigrationSuccessListener() {
        return this.migrationSuccessListener;
    }

    public Consumer<Exception> getMigrationFailedListener() {
        return this.migrationFailedListener;
    }
}

