/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.maven;

import io.moderne.maven.ModerneDryRunMojo;
import io.moderne.serialization.CompressionAlgorithm;
import io.moderne.serialization.ModerneLargeSourceSet;
import io.moderne.serialization.TreeSerializer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.openrewrite.ExecutionContext;
import org.openrewrite.LargeSourceSet;
import org.openrewrite.SourceFile;
import org.openrewrite.config.Environment;
import org.openrewrite.maven.MavenMojoProjectParser;
import org.openrewrite.maven.RewriteRunMojo;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true, defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES)
@Execute(phase=LifecyclePhase.PROCESS_TEST_CLASSES)
public class ModerneRunMojo
extends RewriteRunMojo {
    protected LargeSourceSet loadSourceSet(Path repositoryRoot, Environment env, ExecutionContext ctx) throws DependencyResolutionRequiredException, MojoExecutionException {
        List styles = this.loadStyles(this.project, env);
        MavenMojoProjectParser projectParser = new MavenMojoProjectParser(this.getLog(), this.repositoryRoot(), this.pomCacheEnabled, this.pomCacheDirectory, this.runtime, this.skipMavenParsing, (Collection)this.getExclusions(), (Collection)this.getPlainTextMasks(), this.sizeThresholdMb, this.mavenSession, this.settingsDecrypter, this.runPerSubmodule);
        try {
            Path lstDirectory = Files.createTempDirectory("moderne-lst", new FileAttribute[0]);
            Path runDirectory = Files.createTempDirectory("moderne-run", new FileAttribute[0]);
            Stream asts = projectParser.listSourceFiles(this.project, styles, ctx);
            TreeSerializer.builder().build().write((Stream<SourceFile>)asts, lstDirectory, new CompressionAlgorithm[0]);
            return new ModerneLargeSourceSet(ModerneDryRunMojo.class.getClassLoader(), lstDirectory, runDirectory);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }
}

