/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.proxy.android;

import android.os.Build;
import android.os.Debug;
import dalvik.system.BaseDexClassLoader;
import io.mockk.proxy.MockKAgentException;
import io.mockk.proxy.android.transformation.InliningClassTransformer;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.ProtectionDomain;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\nJ\t\u0010\u000e\u001a\u00020\nH\u0082 J \u0010\u000f\u001a\u00020\n2\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0011H\u0082 \u00a2\u0006\u0002\u0010\u0013J\t\u0010\u0014\u001a\u00020\nH\u0082 J\u001d\u0010\u0015\u001a\u00020\n2\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0011\u00a2\u0006\u0002\u0010\u0013J6\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u0017J\u0014\u0010 \u001a\u00020!2\f\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006#"}, d2={"Lio/mockk/proxy/android/JvmtiAgent;", "", "()V", "transformer", "Lio/mockk/proxy/android/transformation/InliningClassTransformer;", "getTransformer", "()Lio/mockk/proxy/android/transformation/InliningClassTransformer;", "setTransformer", "(Lio/mockk/proxy/android/transformation/InliningClassTransformer;)V", "appendToBootstrapClassLoaderSearch", "", "inStream", "Ljava/io/InputStream;", "disconnect", "nativeRegisterTransformerHook", "nativeRetransformClasses", "classes", "", "Ljava/lang/Class;", "([Ljava/lang/Class;)V", "nativeUnregisterTransformerHook", "requestTransformClasses", "runTransformers", "", "loader", "Ljava/lang/ClassLoader;", "className", "", "classBeingRedefined", "protectionDomain", "Ljava/security/ProtectionDomain;", "classfileBuffer", "shouldTransform", "", "Companion", "mockk-agent-android_release"})
@SourceDebugExtension(value={"SMAP\nJvmtiAgent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmtiAgent.kt\nio/mockk/proxy/android/JvmtiAgent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
public final class JvmtiAgent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private InliningClassTransformer transformer;
    @NotNull
    private static final String libName = "libmockkjvmtiagent.so";
    @NotNull
    private static final Object lock = new Object();

    public JvmtiAgent() {
        ClassLoader classLoader;
        if (Build.VERSION.SDK_INT < 28) {
            throw new MockKAgentException("Requires API level 28. API level is " + Build.VERSION.SDK_INT);
        }
        if (!Intrinsics.areEqual((Object)Build.VERSION.CODENAME, (Object)"P")) {
            // empty if block
        }
        BaseDexClassLoader baseDexClassLoader = (classLoader = JvmtiAgent.class.getClassLoader()) instanceof BaseDexClassLoader ? (BaseDexClassLoader)classLoader : null;
        if (baseDexClassLoader == null) {
            throw new MockKAgentException("Could not load jvmti plugin as AndroidMockKJvmtiAgent class was not loaded by a BaseDexClassLoader");
        }
        BaseDexClassLoader cl = baseDexClassLoader;
        Debug.attachJvmtiAgent((String)libName, null, (ClassLoader)((ClassLoader)cl));
        this.nativeRegisterTransformerHook();
    }

    @Nullable
    public final InliningClassTransformer getTransformer() {
        return this.transformer;
    }

    public final void setTransformer(@Nullable InliningClassTransformer inliningClassTransformer) {
        this.transformer = inliningClassTransformer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void appendToBootstrapClassLoaderSearch(@NotNull InputStream inStream) {
        File file;
        Intrinsics.checkNotNullParameter((Object)inStream, (String)"inStream");
        File $this$appendToBootstrapClassLoaderSearch_u24lambda_u240 = file = File.createTempFile("mockk-boot", ".jar");
        boolean bl = false;
        $this$appendToBootstrapClassLoaderSearch_u24lambda_u240.deleteOnExit();
        File it = file;
        boolean bl2 = false;
        Closeable closeable = new FileOutputStream(it);
        Throwable throwable = null;
        try {
            FileOutputStream it2 = (FileOutputStream)closeable;
            boolean bl3 = false;
            ByteStreamsKt.copyTo$default((InputStream)inStream, (OutputStream)it2, (int)0, (int)2, null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        File jarFile = file;
        String string = jarFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        JvmtiAgent.Companion.nativeAppendToBootstrapClassLoaderSearch(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void requestTransformClasses(@NotNull Class<?>[] classes) {
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        Object object = lock;
        synchronized (object) {
            boolean bl = false;
            this.nativeRetransformClasses(classes);
            Unit unit = Unit.INSTANCE;
        }
    }

    public final boolean shouldTransform(@Nullable Class<?> classBeingRedefined) {
        if (classBeingRedefined == null) {
            return false;
        }
        InliningClassTransformer inliningClassTransformer = this.transformer;
        return inliningClassTransformer != null ? inliningClassTransformer.shouldTransform(classBeingRedefined) : false;
    }

    @NotNull
    public final byte[] runTransformers(@Nullable ClassLoader loader, @NotNull String className, @NotNull Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, @NotNull byte[] classfileBuffer) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)className, (String)"className");
                Intrinsics.checkNotNullParameter(classBeingRedefined, (String)"classBeingRedefined");
                Intrinsics.checkNotNullParameter((Object)classfileBuffer, (String)"classfileBuffer");
                object = this.transformer;
                if (object == null) break block2;
                byte[] byArray = ((InliningClassTransformer)object).transform(classBeingRedefined, classfileBuffer);
                object = byArray;
                if (byArray != null) break block3;
            }
            object = classfileBuffer;
        }
        return object;
    }

    public final void disconnect() {
        this.nativeUnregisterTransformerHook();
    }

    private final native void nativeRegisterTransformerHook();

    private final native void nativeUnregisterTransformerHook();

    private final native void nativeRetransformClasses(Class<?>[] var1);

    @JvmStatic
    private static final native void nativeAppendToBootstrapClassLoaderSearch(String var0);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0083 R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/mockk/proxy/android/JvmtiAgent$Companion;", "", "()V", "libName", "", "lock", "nativeAppendToBootstrapClassLoaderSearch", "", "absolutePath", "mockk-agent-android_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private final void nativeAppendToBootstrapClassLoaderSearch(String absolutePath) {
            JvmtiAgent.nativeAppendToBootstrapClassLoaderSearch(absolutePath);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

