/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.vector.request.ranker;

import com.google.gson.JsonArray;
import io.milvus.common.clientenum.FunctionType;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ModelRanker
extends CreateCollectionReq.Function {
    private String provider;
    private List<String> queries;
    private String endpoint;

    private ModelRanker(ModelRankerBuilder builder) {
        super(builder);
        this.provider = builder.provider;
        this.queries = builder.queries;
        this.endpoint = builder.endpoint;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public List<String> getQueries() {
        return this.queries;
    }

    public void setQueries(List<String> queries) {
        this.queries = queries;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public FunctionType getFunctionType() {
        return FunctionType.RERANK;
    }

    @Override
    public Map<String, String> getParams() {
        Map<String, String> props = super.getParams();
        props.put("reranker", "model");
        props.put("provider", this.provider);
        JsonArray json = new JsonArray();
        this.queries.forEach(arg_0 -> ((JsonArray)json).add(arg_0));
        props.put("queries", json.toString());
        if (this.endpoint != null) {
            props.put("endpoint", this.endpoint);
        }
        return props;
    }

    @Override
    public String toString() {
        return "ModelRanker{provider='" + this.provider + '\'' + ", queries=" + this.queries + ", endpoint='" + this.endpoint + '\'' + ", name='" + this.getName() + '\'' + ", description='" + this.getDescription() + '\'' + ", functionType=" + (Object)((Object)this.getFunctionType()) + ", inputFieldNames=" + this.getInputFieldNames() + ", outputFieldNames=" + this.getOutputFieldNames() + ", params=" + this.getParams() + '}';
    }

    public static ModelRankerBuilder builder() {
        return new ModelRankerBuilder();
    }

    public static class ModelRankerBuilder
    extends CreateCollectionReq.Function.FunctionBuilder<ModelRankerBuilder> {
        private String provider = "tei";
        private List<String> queries = new ArrayList<String>();
        private String endpoint;

        private ModelRankerBuilder() {
        }

        public ModelRankerBuilder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public ModelRankerBuilder queries(List<String> queries) {
            this.queries = queries;
            return this;
        }

        public ModelRankerBuilder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public ModelRanker build() {
            return new ModelRanker(this);
        }
    }
}

