/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.vector.request;

import io.milvus.v2.common.ConsistencyLevel;
import io.milvus.v2.common.IndexParam;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import io.milvus.v2.service.vector.request.FunctionScore;
import io.milvus.v2.service.vector.request.data.BaseVector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SearchReq {
    private String databaseName;
    private String collectionName;
    private List<String> partitionNames;
    private String annsField;
    private IndexParam.MetricType metricType;
    @Deprecated
    private int topK;
    private String filter;
    private List<String> outputFields;
    private List<BaseVector> data;
    private long offset;
    private long limit;
    private int roundDecimal;
    private Map<String, Object> searchParams;
    private long guaranteeTimestamp;
    private Long gracefulTime;
    private ConsistencyLevel consistencyLevel;
    private boolean ignoreGrowing;
    private String timezone;
    private String groupByFieldName;
    private Integer groupSize;
    private Boolean strictGroupSize;
    @Deprecated
    private CreateCollectionReq.Function ranker;
    private FunctionScore functionScore;
    private Map<String, Object> filterTemplateValues;

    private SearchReq(SearchReqBuilder builder) {
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.partitionNames = builder.partitionNames;
        this.annsField = builder.annsField;
        this.metricType = builder.metricType;
        this.topK = builder.topK;
        this.filter = builder.filter;
        this.outputFields = builder.outputFields;
        this.data = builder.data;
        this.offset = builder.offset;
        this.limit = builder.limit;
        this.roundDecimal = builder.roundDecimal;
        this.searchParams = builder.searchParams;
        this.guaranteeTimestamp = builder.guaranteeTimestamp;
        this.gracefulTime = builder.gracefulTime;
        this.consistencyLevel = builder.consistencyLevel;
        this.ignoreGrowing = builder.ignoreGrowing;
        this.groupByFieldName = builder.groupByFieldName;
        this.groupSize = builder.groupSize;
        this.strictGroupSize = builder.strictGroupSize;
        this.ranker = builder.ranker;
        this.functionScore = builder.functionScore;
        this.filterTemplateValues = builder.filterTemplateValues;
        this.timezone = builder.timezone;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public List<String> getPartitionNames() {
        return this.partitionNames;
    }

    public void setPartitionNames(List<String> partitionNames) {
        this.partitionNames = partitionNames;
    }

    public String getAnnsField() {
        return this.annsField;
    }

    public void setAnnsField(String annsField) {
        this.annsField = annsField;
    }

    public IndexParam.MetricType getMetricType() {
        return this.metricType;
    }

    public void setMetricType(IndexParam.MetricType metricType) {
        this.metricType = metricType;
    }

    @Deprecated
    public int getTopK() {
        return this.topK;
    }

    @Deprecated
    public void setTopK(int topK) {
        this.topK = topK;
        this.limit = topK;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public List<String> getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(List<String> outputFields) {
        this.outputFields = outputFields;
    }

    public List<BaseVector> getData() {
        return this.data;
    }

    public void setData(List<BaseVector> data) {
        this.data = data;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long limit) {
        this.limit = limit;
        this.topK = (int)limit;
    }

    public int getRoundDecimal() {
        return this.roundDecimal;
    }

    public void setRoundDecimal(int roundDecimal) {
        this.roundDecimal = roundDecimal;
    }

    public Map<String, Object> getSearchParams() {
        return this.searchParams;
    }

    public void setSearchParams(Map<String, Object> searchParams) {
        this.searchParams = searchParams;
    }

    public long getGuaranteeTimestamp() {
        return this.guaranteeTimestamp;
    }

    public void setGuaranteeTimestamp(long guaranteeTimestamp) {
        this.guaranteeTimestamp = guaranteeTimestamp;
    }

    public Long getGracefulTime() {
        return this.gracefulTime;
    }

    public void setGracefulTime(Long gracefulTime) {
        this.gracefulTime = gracefulTime;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    public boolean isIgnoreGrowing() {
        return this.ignoreGrowing;
    }

    public void setIgnoreGrowing(boolean ignoreGrowing) {
        this.ignoreGrowing = ignoreGrowing;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public String getGroupByFieldName() {
        return this.groupByFieldName;
    }

    public void setGroupByFieldName(String groupByFieldName) {
        this.groupByFieldName = groupByFieldName;
    }

    public Integer getGroupSize() {
        return this.groupSize;
    }

    public void setGroupSize(Integer groupSize) {
        this.groupSize = groupSize;
    }

    public Boolean getStrictGroupSize() {
        return this.strictGroupSize;
    }

    public void setStrictGroupSize(Boolean strictGroupSize) {
        this.strictGroupSize = strictGroupSize;
    }

    public CreateCollectionReq.Function getRanker() {
        return this.ranker;
    }

    public void setRanker(CreateCollectionReq.Function ranker) {
        this.ranker = ranker;
    }

    public FunctionScore getFunctionScore() {
        return this.functionScore;
    }

    public void setFunctionScore(FunctionScore functionScore) {
        this.functionScore = functionScore;
    }

    public Map<String, Object> getFilterTemplateValues() {
        return this.filterTemplateValues;
    }

    public void setFilterTemplateValues(Map<String, Object> filterTemplateValues) {
        this.filterTemplateValues = filterTemplateValues;
    }

    public String toString() {
        return "SearchReq{databaseName='" + this.databaseName + '\'' + ", collectionName='" + this.collectionName + '\'' + ", partitionNames=" + this.partitionNames + ", annsField='" + this.annsField + '\'' + ", metricType=" + (Object)((Object)this.metricType) + ", topK=" + this.topK + ", filter='" + this.filter + '\'' + ", outputFields=" + this.outputFields + ", data=" + this.data + ", offset=" + this.offset + ", limit=" + this.limit + ", roundDecimal=" + this.roundDecimal + ", searchParams=" + this.searchParams + ", guaranteeTimestamp=" + this.guaranteeTimestamp + ", gracefulTime=" + this.gracefulTime + ", consistencyLevel=" + (Object)((Object)this.consistencyLevel) + ", ignoreGrowing=" + this.ignoreGrowing + ", timezone='" + this.timezone + '\'' + ", groupByFieldName='" + this.groupByFieldName + '\'' + ", groupSize=" + this.groupSize + ", strictGroupSize=" + this.strictGroupSize + ", ranker=" + this.ranker + ", functionScore=" + this.functionScore + '}';
    }

    public static SearchReqBuilder builder() {
        return new SearchReqBuilder();
    }

    public static class SearchReqBuilder {
        private String databaseName;
        private String collectionName;
        private List<String> partitionNames = new ArrayList<String>();
        private String annsField = "";
        private IndexParam.MetricType metricType;
        private int topK = 0;
        private String filter;
        private List<String> outputFields = new ArrayList<String>();
        private List<BaseVector> data = new ArrayList<BaseVector>();
        private long offset;
        private long limit = 0L;
        private int roundDecimal = -1;
        private Map<String, Object> searchParams = new HashMap<String, Object>();
        private long guaranteeTimestamp;
        private Long gracefulTime = 5000L;
        private ConsistencyLevel consistencyLevel = null;
        private boolean ignoreGrowing;
        private String timezone = "";
        private String groupByFieldName;
        private Integer groupSize;
        private Boolean strictGroupSize;
        private CreateCollectionReq.Function ranker;
        private FunctionScore functionScore;
        private Map<String, Object> filterTemplateValues = new HashMap<String, Object>();

        private SearchReqBuilder() {
        }

        public SearchReqBuilder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public SearchReqBuilder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public SearchReqBuilder partitionNames(List<String> partitionNames) {
            this.partitionNames = partitionNames;
            return this;
        }

        public SearchReqBuilder annsField(String annsField) {
            this.annsField = annsField;
            return this;
        }

        public SearchReqBuilder metricType(IndexParam.MetricType metricType) {
            this.metricType = metricType;
            return this;
        }

        @Deprecated
        public SearchReqBuilder topK(int topK) {
            this.topK = topK;
            this.limit = topK;
            return this;
        }

        public SearchReqBuilder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public SearchReqBuilder outputFields(List<String> outputFields) {
            this.outputFields = outputFields;
            return this;
        }

        public SearchReqBuilder data(List<BaseVector> data) {
            this.data = data;
            return this;
        }

        public SearchReqBuilder offset(long offset) {
            this.offset = offset;
            return this;
        }

        public SearchReqBuilder limit(long limit) {
            this.topK = (int)limit;
            this.limit = limit;
            return this;
        }

        public SearchReqBuilder roundDecimal(int roundDecimal) {
            this.roundDecimal = roundDecimal;
            return this;
        }

        public SearchReqBuilder searchParams(Map<String, Object> searchParams) {
            this.searchParams = searchParams;
            return this;
        }

        public SearchReqBuilder guaranteeTimestamp(long guaranteeTimestamp) {
            this.guaranteeTimestamp = guaranteeTimestamp;
            return this;
        }

        public SearchReqBuilder gracefulTime(Long gracefulTime) {
            this.gracefulTime = gracefulTime;
            return this;
        }

        public SearchReqBuilder consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        public SearchReqBuilder ignoreGrowing(boolean ignoreGrowing) {
            this.ignoreGrowing = ignoreGrowing;
            return this;
        }

        public SearchReqBuilder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public SearchReqBuilder groupByFieldName(String groupByFieldName) {
            this.groupByFieldName = groupByFieldName;
            return this;
        }

        public SearchReqBuilder groupSize(Integer groupSize) {
            this.groupSize = groupSize;
            return this;
        }

        public SearchReqBuilder strictGroupSize(Boolean strictGroupSize) {
            this.strictGroupSize = strictGroupSize;
            return this;
        }

        public SearchReqBuilder ranker(CreateCollectionReq.Function ranker) {
            this.ranker = ranker;
            return this;
        }

        public SearchReqBuilder functionScore(FunctionScore functionScore) {
            this.functionScore = functionScore;
            return this;
        }

        public SearchReqBuilder filterTemplateValues(Map<String, Object> filterTemplateValues) {
            this.filterTemplateValues = filterTemplateValues;
            return this;
        }

        public SearchReq build() {
            return new SearchReq(this);
        }
    }
}

