/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.partition;

import io.milvus.grpc.BoolResponse;
import io.milvus.grpc.CreatePartitionRequest;
import io.milvus.grpc.DropPartitionRequest;
import io.milvus.grpc.GetLoadingProgressRequest;
import io.milvus.grpc.GetLoadingProgressResponse;
import io.milvus.grpc.GetPartitionStatisticsRequest;
import io.milvus.grpc.GetPartitionStatisticsResponse;
import io.milvus.grpc.HasPartitionRequest;
import io.milvus.grpc.LoadPartitionsRequest;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.grpc.ReleasePartitionsRequest;
import io.milvus.grpc.ShowPartitionsRequest;
import io.milvus.grpc.ShowPartitionsResponse;
import io.milvus.grpc.Status;
import io.milvus.v2.exception.ErrorCode;
import io.milvus.v2.exception.MilvusClientException;
import io.milvus.v2.service.BaseService;
import io.milvus.v2.service.partition.request.CreatePartitionReq;
import io.milvus.v2.service.partition.request.DropPartitionReq;
import io.milvus.v2.service.partition.request.GetPartitionStatsReq;
import io.milvus.v2.service.partition.request.HasPartitionReq;
import io.milvus.v2.service.partition.request.ListPartitionsReq;
import io.milvus.v2.service.partition.request.LoadPartitionsReq;
import io.milvus.v2.service.partition.request.ReleasePartitionsReq;
import io.milvus.v2.service.partition.response.GetPartitionStatsResp;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class PartitionService
extends BaseService {
    public Void createPartition(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, CreatePartitionReq request) {
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        String partitionName = request.getPartitionName();
        String title = String.format("Create partition: '%s' in collection: '%s' in database: '%s'", partitionName, collectionName, dbName);
        CreatePartitionRequest.Builder builder = CreatePartitionRequest.newBuilder().setCollectionName(collectionName).setPartitionName(partitionName);
        if (StringUtils.isNotEmpty((CharSequence)dbName)) {
            builder.setDbName(dbName);
        }
        Status status = blockingStub.createPartition(builder.build());
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public Void dropPartition(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DropPartitionReq request) {
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        String partitionName = request.getPartitionName();
        String title = String.format("Drop partition: '%s' in collection: '%s' in database: '%s'", partitionName, collectionName, dbName);
        DropPartitionRequest.Builder builder = DropPartitionRequest.newBuilder().setCollectionName(collectionName).setPartitionName(partitionName);
        if (StringUtils.isNotEmpty((CharSequence)dbName)) {
            builder.setDbName(dbName);
        }
        Status status = blockingStub.dropPartition(builder.build());
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public Boolean hasPartition(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, HasPartitionReq request) {
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        String partitionName = request.getPartitionName();
        String title = String.format("Has partition: '%s' in collection: '%s' in database: '%s'", partitionName, collectionName, dbName);
        HasPartitionRequest.Builder builder = HasPartitionRequest.newBuilder().setCollectionName(collectionName).setPartitionName(partitionName);
        if (StringUtils.isNotEmpty((CharSequence)dbName)) {
            builder.setDbName(dbName);
        }
        BoolResponse boolResponse = blockingStub.hasPartition(builder.build());
        this.rpcUtils.handleResponse(title, boolResponse.getStatus());
        return boolResponse.getValue();
    }

    public List<String> listPartitions(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, ListPartitionsReq request) {
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        String title = String.format("List partitions in collection: '%s' in database: '%s'", collectionName, dbName);
        ShowPartitionsRequest.Builder builder = ShowPartitionsRequest.newBuilder().setCollectionName(request.getCollectionName());
        if (StringUtils.isNotEmpty((CharSequence)dbName)) {
            builder.setDbName(dbName);
        }
        ShowPartitionsResponse showPartitionsResponse = blockingStub.showPartitions(builder.build());
        this.rpcUtils.handleResponse(title, showPartitionsResponse.getStatus());
        return showPartitionsResponse.getPartitionNamesList();
    }

    public GetPartitionStatsResp getPartitionStats(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, GetPartitionStatsReq request) {
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        String partitionName = request.getPartitionName();
        String title = String.format("Get statistics of partition: '%s' in collection: '%s' in database: '%s'", partitionName, collectionName, dbName);
        GetPartitionStatisticsRequest.Builder builder = GetPartitionStatisticsRequest.newBuilder().setCollectionName(collectionName).setPartitionName(partitionName);
        if (StringUtils.isNotEmpty((CharSequence)dbName)) {
            builder.setDbName(dbName);
        }
        GetPartitionStatisticsResponse response = blockingStub.getPartitionStatistics(builder.build());
        this.rpcUtils.handleResponse(title, response.getStatus());
        GetPartitionStatsResp getPartitionStatsResp = GetPartitionStatsResp.builder().numOfEntities(response.getStatsList().stream().filter(stat -> stat.getKey().equals("row_count")).map(stat -> Long.parseLong(stat.getValue())).findFirst().get()).build();
        return getPartitionStatsResp;
    }

    public Void loadPartitions(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, LoadPartitionsReq request) {
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        List<String> partitionNames = request.getPartitionNames();
        String title = String.format("Load partitions: %s in collection: '%s' in database: '%s'", partitionNames, collectionName, dbName);
        LoadPartitionsRequest.Builder builder = LoadPartitionsRequest.newBuilder().setCollectionName(collectionName).addAllPartitionNames(partitionNames).setReplicaNumber(request.getNumReplicas()).setRefresh(request.getRefresh()).addAllLoadFields(request.getLoadFields()).setSkipLoadDynamicField(request.getSkipLoadDynamicField()).addAllResourceGroups(request.getResourceGroups());
        if (StringUtils.isNotEmpty((CharSequence)dbName)) {
            builder.setDbName(dbName);
        }
        Status status = blockingStub.loadPartitions(builder.build());
        this.rpcUtils.handleResponse(title, status);
        if (request.getSync().booleanValue()) {
            this.WaitForLoadPartitions(blockingStub, dbName, collectionName, partitionNames, request.getTimeout());
        }
        return null;
    }

    public Void releasePartitions(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, ReleasePartitionsReq request) {
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        List<String> partitionNames = request.getPartitionNames();
        String title = String.format("Release partitions: %s in collection: '%s' in database: '%s'", partitionNames, collectionName, dbName);
        ReleasePartitionsRequest.Builder builder = ReleasePartitionsRequest.newBuilder().setCollectionName(collectionName).addAllPartitionNames(partitionNames);
        if (StringUtils.isNotEmpty((CharSequence)dbName)) {
            builder.setDbName(dbName);
        }
        Status status = blockingStub.releasePartitions(builder.build());
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    private void WaitForLoadPartitions(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, String dbName, String collectionName, List<String> partitions, long timeoutMs) {
        long startTime = System.currentTimeMillis();
        while (true) {
            GetLoadingProgressRequest.Builder builder = GetLoadingProgressRequest.newBuilder().setCollectionName(collectionName).addAllPartitionNames(partitions);
            if (StringUtils.isNotEmpty((CharSequence)dbName)) {
                builder.setDbName(dbName);
            }
            GetLoadingProgressResponse response = blockingStub.getLoadingProgress(builder.build());
            String title = String.format("Get loading progress of collection: '%s' in database: '%s'", collectionName, dbName);
            this.rpcUtils.handleResponse(title, response.getStatus());
            if (response.getProgress() >= 100L) {
                return;
            }
            if (System.currentTimeMillis() - startTime > timeoutMs) {
                throw new MilvusClientException(ErrorCode.SERVER_ERROR, "Load partitions timeout");
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("Thread was interrupted, failed to complete operation");
                return;
            }
        }
    }
}

