/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.cdc.request;

import io.milvus.grpc.ReplicateConfiguration;
import io.milvus.v2.service.cdc.request.CrossClusterTopology;
import io.milvus.v2.service.cdc.request.MilvusCluster;
import java.util.List;

public class ReplicateConfiguration {
    private List<MilvusCluster> clusters;
    private List<CrossClusterTopology> crossClusterTopologies;

    public io.milvus.grpc.ReplicateConfiguration toGRPC() {
        ReplicateConfiguration.Builder builder = io.milvus.grpc.ReplicateConfiguration.newBuilder();
        if (this.clusters != null) {
            for (MilvusCluster cluster : this.clusters) {
                builder.addClusters(cluster.toGRPC());
            }
        }
        if (this.crossClusterTopologies != null) {
            for (CrossClusterTopology topology : this.crossClusterTopologies) {
                builder.addCrossClusterTopology(topology.toGRPC());
            }
        }
        return builder.build();
    }

    private ReplicateConfiguration(ReplicateConfigurationBuilder builder) {
        this.clusters = builder.clusters;
        this.crossClusterTopologies = builder.crossClusterTopologies;
    }

    public List<MilvusCluster> getClusters() {
        return this.clusters;
    }

    public void setClusters(List<MilvusCluster> clusters) {
        this.clusters = clusters;
    }

    public List<CrossClusterTopology> getCrossClusterTopologies() {
        return this.crossClusterTopologies;
    }

    public void setCrossClusterTopologies(List<CrossClusterTopology> crossClusterTopologies) {
        this.crossClusterTopologies = crossClusterTopologies;
    }

    public String toString() {
        return "ReplicateConfiguration{clusters=" + this.clusters + ", crossClusterTopologies=" + this.crossClusterTopologies + '}';
    }

    public static ReplicateConfigurationBuilder builder() {
        return new ReplicateConfigurationBuilder();
    }

    public static class ReplicateConfigurationBuilder {
        private List<MilvusCluster> clusters;
        private List<CrossClusterTopology> crossClusterTopologies;

        public ReplicateConfigurationBuilder clusters(List<MilvusCluster> clusters) {
            this.clusters = clusters;
            return this;
        }

        public ReplicateConfigurationBuilder crossClusterTopologies(List<CrossClusterTopology> crossClusterTopologies) {
            this.crossClusterTopologies = crossClusterTopologies;
            return this;
        }

        public ReplicateConfiguration build() {
            return new ReplicateConfiguration(this);
        }
    }
}

