/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.client;

import io.milvus.common.utils.URLParser;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;

public class ConnectConfig {
    private String uri;
    private String token;
    private String username;
    private String password;
    private String dbName;
    private long connectTimeoutMs = 10000L;
    private long keepAliveTimeMs = 55000L;
    private long keepAliveTimeoutMs = 20000L;
    private boolean keepAliveWithoutCalls = false;
    private long rpcDeadlineMs = 0L;
    private String clientKeyPath;
    private String clientPemPath;
    private String caPemPath;
    private String serverPemPath;
    private String serverName;
    private String proxyAddress;
    private Boolean secure = false;
    private long idleTimeoutMs = TimeUnit.MILLISECONDS.convert(24L, TimeUnit.HOURS);
    private boolean enablePrecheck = false;
    private SSLContext sslContext;
    private ThreadLocal<String> clientRequestId;

    private ConnectConfig(ConnectConfigBuilder builder) {
        if (builder.uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        this.uri = builder.uri;
        this.token = builder.token;
        this.username = builder.username;
        this.password = builder.password;
        this.dbName = builder.dbName;
        this.connectTimeoutMs = builder.connectTimeoutMs;
        this.keepAliveTimeMs = builder.keepAliveTimeMs;
        this.keepAliveTimeoutMs = builder.keepAliveTimeoutMs;
        this.keepAliveWithoutCalls = builder.keepAliveWithoutCalls;
        this.rpcDeadlineMs = builder.rpcDeadlineMs;
        this.clientKeyPath = builder.clientKeyPath;
        this.clientPemPath = builder.clientPemPath;
        this.caPemPath = builder.caPemPath;
        this.serverPemPath = builder.serverPemPath;
        this.serverName = builder.serverName;
        this.proxyAddress = builder.proxyAddress;
        this.secure = builder.secure;
        this.idleTimeoutMs = builder.idleTimeoutMs;
        this.sslContext = builder.sslContext;
        this.clientRequestId = builder.clientRequestId;
        this.enablePrecheck = builder.enablePrecheck;
    }

    public static ConnectConfigBuilder builder() {
        return new ConnectConfigBuilder();
    }

    public String getUri() {
        return this.uri;
    }

    public String getToken() {
        return this.token;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public long getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    public long getKeepAliveTimeMs() {
        return this.keepAliveTimeMs;
    }

    public long getKeepAliveTimeoutMs() {
        return this.keepAliveTimeoutMs;
    }

    public boolean isKeepAliveWithoutCalls() {
        return this.keepAliveWithoutCalls;
    }

    public long getRpcDeadlineMs() {
        return this.rpcDeadlineMs;
    }

    public String getClientKeyPath() {
        return this.clientKeyPath;
    }

    public String getClientPemPath() {
        return this.clientPemPath;
    }

    public String getCaPemPath() {
        return this.caPemPath;
    }

    public String getServerPemPath() {
        return this.serverPemPath;
    }

    public String getServerName() {
        return this.serverName;
    }

    public Boolean getSecure() {
        return this.secure;
    }

    public long getIdleTimeoutMs() {
        return this.idleTimeoutMs;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public ThreadLocal<String> getClientRequestId() {
        return this.clientRequestId;
    }

    public String getProxyAddress() {
        return this.proxyAddress;
    }

    public boolean isEnablePrecheck() {
        return this.enablePrecheck;
    }

    public void setUri(String uri) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        this.uri = uri;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setConnectTimeoutMs(long connectTimeoutMs) {
        this.connectTimeoutMs = connectTimeoutMs;
    }

    public void setKeepAliveTimeMs(long keepAliveTimeMs) {
        this.keepAliveTimeMs = keepAliveTimeMs;
    }

    public void setKeepAliveTimeoutMs(long keepAliveTimeoutMs) {
        this.keepAliveTimeoutMs = keepAliveTimeoutMs;
    }

    public void setKeepAliveWithoutCalls(boolean keepAliveWithoutCalls) {
        this.keepAliveWithoutCalls = keepAliveWithoutCalls;
    }

    public void setRpcDeadlineMs(long rpcDeadlineMs) {
        this.rpcDeadlineMs = rpcDeadlineMs;
    }

    public void setClientKeyPath(String clientKeyPath) {
        this.clientKeyPath = clientKeyPath;
    }

    public void setClientPemPath(String clientPemPath) {
        this.clientPemPath = clientPemPath;
    }

    public void setCaPemPath(String caPemPath) {
        this.caPemPath = caPemPath;
    }

    public void setServerPemPath(String serverPemPath) {
        this.serverPemPath = serverPemPath;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setProxyAddress(String proxyAddress) {
        this.proxyAddress = proxyAddress;
    }

    public void setSecure(Boolean secure) {
        this.secure = secure;
    }

    public void setEnablePrecheck(boolean enablePrecheck) {
        this.enablePrecheck = enablePrecheck;
    }

    public void setIdleTimeoutMs(long idleTimeoutMs) {
        this.idleTimeoutMs = idleTimeoutMs;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setClientRequestId(ThreadLocal<String> clientRequestId) {
        this.clientRequestId = clientRequestId;
    }

    public String getHost() {
        URLParser urlParser = new URLParser(this.uri);
        return urlParser.getHostname();
    }

    public int getPort() {
        URLParser urlParser = new URLParser(this.uri);
        int port = urlParser.getPort();
        if (Pattern.matches("^(https://in03-.{20,}zilliz.*.(com|cn))|(https://in0\\d{1}-.{15,}serverless.*zilliz.*.(com|cn))$", this.uri)) {
            port = 443;
        }
        return port;
    }

    public String getAuthorization() {
        if (this.token != null) {
            return this.token;
        }
        if (this.username != null && this.password != null) {
            return this.username + ":" + this.password;
        }
        return null;
    }

    public String getDbName() {
        URLParser urlParser = new URLParser(this.uri);
        return StringUtils.isNotEmpty((CharSequence)urlParser.getDatabase()) ? urlParser.getDatabase() : this.dbName;
    }

    public Boolean isSecure() {
        if (this.uri.startsWith("https")) {
            return true;
        }
        return this.secure;
    }

    public String toString() {
        return "ConnectConfig{uri='" + this.uri + '\'' + ", token='" + this.token + '\'' + ", username='" + this.username + '\'' + ", password='" + this.password + '\'' + ", dbName='" + this.dbName + '\'' + ", connectTimeoutMs=" + this.connectTimeoutMs + ", keepAliveTimeMs=" + this.keepAliveTimeMs + ", keepAliveTimeoutMs=" + this.keepAliveTimeoutMs + ", keepAliveWithoutCalls=" + this.keepAliveWithoutCalls + ", rpcDeadlineMs=" + this.rpcDeadlineMs + ", clientKeyPath='" + this.clientKeyPath + '\'' + ", clientPemPath='" + this.clientPemPath + '\'' + ", caPemPath='" + this.caPemPath + '\'' + ", serverPemPath='" + this.serverPemPath + '\'' + ", serverName='" + this.serverName + '\'' + ", proxyAddress='" + this.proxyAddress + '\'' + ", secure=" + this.secure + ", enablePrecheck=" + this.enablePrecheck + ", idleTimeoutMs=" + this.idleTimeoutMs + ", sslContext=" + this.sslContext + ", clientRequestId=" + this.clientRequestId + '}';
    }

    public static class ConnectConfigBuilder {
        private String uri;
        private String token;
        private String username;
        private String password;
        private String dbName;
        private long connectTimeoutMs = 10000L;
        private long keepAliveTimeMs = 55000L;
        private long keepAliveTimeoutMs = 20000L;
        private boolean keepAliveWithoutCalls = false;
        private long rpcDeadlineMs = 0L;
        private String clientKeyPath;
        private String clientPemPath;
        private String caPemPath;
        private String serverPemPath;
        private String serverName;
        private String proxyAddress;
        private Boolean secure = false;
        private long idleTimeoutMs = TimeUnit.MILLISECONDS.convert(24L, TimeUnit.HOURS);
        private SSLContext sslContext;
        private ThreadLocal<String> clientRequestId;
        private boolean enablePrecheck = false;

        public ConnectConfigBuilder uri(String uri) {
            if (uri == null) {
                throw new NullPointerException("uri is marked non-null but is null");
            }
            this.uri = uri;
            return this;
        }

        public ConnectConfigBuilder token(String token) {
            this.token = token;
            return this;
        }

        public ConnectConfigBuilder username(String username) {
            if (username == null || username.trim().isEmpty()) {
                throw new IllegalArgumentException("Username cannot be null or blank");
            }
            this.username = username;
            return this;
        }

        public ConnectConfigBuilder password(String password) {
            this.password = password;
            return this;
        }

        public ConnectConfigBuilder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public ConnectConfigBuilder connectTimeoutMs(long connectTimeoutMs) {
            this.connectTimeoutMs = connectTimeoutMs;
            return this;
        }

        public ConnectConfigBuilder keepAliveTimeMs(long keepAliveTimeMs) {
            this.keepAliveTimeMs = keepAliveTimeMs;
            return this;
        }

        public ConnectConfigBuilder keepAliveTimeoutMs(long keepAliveTimeoutMs) {
            this.keepAliveTimeoutMs = keepAliveTimeoutMs;
            return this;
        }

        public ConnectConfigBuilder keepAliveWithoutCalls(boolean keepAliveWithoutCalls) {
            this.keepAliveWithoutCalls = keepAliveWithoutCalls;
            return this;
        }

        public ConnectConfigBuilder rpcDeadlineMs(long rpcDeadlineMs) {
            this.rpcDeadlineMs = rpcDeadlineMs;
            return this;
        }

        public ConnectConfigBuilder clientKeyPath(String clientKeyPath) {
            this.clientKeyPath = clientKeyPath;
            return this;
        }

        public ConnectConfigBuilder clientPemPath(String clientPemPath) {
            this.clientPemPath = clientPemPath;
            return this;
        }

        public ConnectConfigBuilder caPemPath(String caPemPath) {
            this.caPemPath = caPemPath;
            return this;
        }

        public ConnectConfigBuilder serverPemPath(String serverPemPath) {
            this.serverPemPath = serverPemPath;
            return this;
        }

        public ConnectConfigBuilder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public ConnectConfigBuilder proxyAddress(String proxyAddress) {
            this.proxyAddress = proxyAddress;
            return this;
        }

        public ConnectConfigBuilder secure(Boolean secure) {
            this.secure = secure;
            return this;
        }

        public ConnectConfigBuilder enablePrecheck(boolean enablePrecheck) {
            this.enablePrecheck = enablePrecheck;
            return this;
        }

        public ConnectConfigBuilder idleTimeoutMs(long idleTimeoutMs) {
            this.idleTimeoutMs = idleTimeoutMs;
            return this;
        }

        public ConnectConfigBuilder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public ConnectConfigBuilder clientRequestId(ThreadLocal<String> clientRequestId) {
            this.clientRequestId = clientRequestId;
            return this;
        }

        public ConnectConfig build() {
            return new ConnectConfig(this);
        }
    }
}

