/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.response;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.milvus.exception.ParamException;
import io.milvus.grpc.FieldData;
import io.milvus.grpc.QueryResults;
import io.milvus.response.FieldDataWrapper;
import io.milvus.response.basic.RowRecordWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class QueryResultsWrapper
extends RowRecordWrapper {
    private final QueryResults results;

    public QueryResultsWrapper(QueryResults results) {
        if (results == null) {
            throw new IllegalArgumentException("QueryResults cannot be null");
        }
        this.results = results;
    }

    public FieldDataWrapper getFieldWrapper(String fieldName) throws ParamException {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        List<FieldData> fields = this.results.getFieldsDataList();
        for (FieldData field : fields) {
            if (fieldName.compareTo(field.getFieldName()) != 0) continue;
            return this.getFieldWrapperInternal(field);
        }
        throw new ParamException("The field name doesn't exist");
    }

    @Override
    public List<RowRecord> getRowRecords() {
        long rowCount = this.getRowCount();
        ArrayList<RowRecord> records = new ArrayList<RowRecord>();
        for (long i = 0L; i < rowCount; ++i) {
            RowRecord record = this.buildRowRecord(i);
            records.add(record);
        }
        return records;
    }

    protected RowRecord buildRowRecord(long index) {
        RowRecord record = new RowRecord();
        this.buildRowRecord(record, index);
        return record;
    }

    public long getRowCount() {
        List<FieldData> fields = this.results.getFieldsDataList();
        Iterator<FieldData> iterator = fields.iterator();
        if (iterator.hasNext()) {
            FieldData field = iterator.next();
            FieldDataWrapper wrapper = this.getFieldWrapperInternal(field);
            return wrapper.getRowCount();
        }
        return 0L;
    }

    @Override
    protected List<FieldData> getFieldDataList() {
        return this.results.getFieldsDataList();
    }

    @Override
    protected List<String> getOutputFields() {
        return this.results.getOutputFieldsList();
    }

    public static final class RowRecord {
        Map<String, Object> fieldValues = new HashMap<String, Object>();

        public Map<String, Object> getFieldValues() {
            return this.fieldValues;
        }

        public boolean put(String keyName, Object obj) {
            if (this.fieldValues.containsKey(keyName)) {
                return false;
            }
            this.fieldValues.put(keyName, obj);
            return true;
        }

        public Object get(String keyName) throws ParamException {
            JsonObject jsonMata;
            JsonElement innerObj;
            Object meta;
            if (this.fieldValues.isEmpty()) {
                throw new ParamException("This record is empty");
            }
            Object obj = this.fieldValues.get(keyName);
            if (obj == null && (meta = this.fieldValues.get("$meta")) != null && (innerObj = (jsonMata = (JsonObject)meta).get(keyName)) != null) {
                return innerObj;
            }
            return obj;
        }

        public boolean contains(String keyName) {
            return this.fieldValues.containsKey(keyName);
        }

        public String toString() {
            ArrayList pairs = new ArrayList();
            this.fieldValues.forEach((keyName, fieldValue) -> pairs.add(keyName + ":" + fieldValue));
            return ((Object)pairs).toString();
        }
    }
}

