/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.response;

import com.google.common.collect.Lists;
import io.milvus.exception.ParamException;
import io.milvus.grpc.MutationResult;
import java.util.List;

public class MutationResultWrapper {
    private final MutationResult result;

    public MutationResultWrapper(MutationResult result) {
        if (result == null) {
            throw new IllegalArgumentException("MutationResult cannot be null");
        }
        this.result = result;
    }

    public long getInsertCount() {
        return this.result.getInsertCnt();
    }

    public List<Long> getLongIDs() throws ParamException {
        if (this.result.getIDs().hasIntId()) {
            return this.result.getIDs().getIntId().getDataList();
        }
        throw new ParamException("The primary key is not long type, please try getStringIDs()");
    }

    public List<String> getStringIDs() throws ParamException {
        if (this.result.getIDs().hasStrId()) {
            return this.result.getIDs().getStrId().getDataList();
        }
        throw new ParamException("The primary key is not string type, please try getLongIDs()");
    }

    public List<?> getInsertIDs() {
        if (this.result.getIDs().hasIntId()) {
            return this.result.getIDs().getIntId().getDataList();
        }
        if (this.result.getIDs().hasStrId()) {
            return this.result.getIDs().getStrId().getDataList();
        }
        throw new ParamException("No found insertIds, please check your requests");
    }

    public List<?> getDeleteIDs() {
        if (this.result.getIDs().hasIntId()) {
            return this.result.getIDs().getIntId().getDataList();
        }
        if (this.result.getIDs().hasStrId()) {
            return this.result.getIDs().getStrId().getDataList();
        }
        return Lists.newArrayList();
    }

    public long getDeleteCount() {
        return this.result.getDeleteCnt();
    }

    public long getOperationTs() {
        return this.result.getTimestamp();
    }
}

