/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.pool;

import io.milvus.v2.exception.ErrorCode;
import io.milvus.v2.exception.MilvusClientException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolClientFactory<C, T>
extends BaseKeyedPooledObjectFactory<String, T> {
    protected static final Logger logger = LoggerFactory.getLogger(PoolClientFactory.class);
    private final C configDefault;
    private ConcurrentMap<String, C> configForKeys = new ConcurrentHashMap<String, C>();
    private Constructor<?> constructor;
    private Method closeMethod;
    private Method verifyMethod;

    public PoolClientFactory(C configDefault, String clientClassName) throws ClassNotFoundException, NoSuchMethodException {
        this.configDefault = configDefault;
        try {
            Class<?> clientCls = Class.forName(clientClassName);
            Class<?> configCls = Class.forName(configDefault.getClass().getName());
            this.constructor = clientCls.getConstructor(configCls);
            this.closeMethod = clientCls.getMethod("close", Long.TYPE);
            this.verifyMethod = clientCls.getMethod("clientIsReady", new Class[0]);
        }
        catch (Exception e) {
            logger.error("Failed to create client pool factory, exception: ", (Throwable)e);
            throw e;
        }
    }

    public void configForKey(String key, C config) {
        this.configForKeys.put(key, config);
    }

    public C removeConfig(String key) {
        return (C)this.configForKeys.remove(key);
    }

    public Set<String> configKeys() {
        return this.configForKeys.keySet();
    }

    public C getConfig(String key) {
        return (C)this.configForKeys.get(key);
    }

    public T create(String key) throws Exception {
        try {
            Object keyConfig;
            if (logger.isDebugEnabled()) {
                logger.info("PoolClientFactory key: {} creates a client", (Object)key);
            }
            if ((keyConfig = this.configForKeys.get(key)) == null) {
                return (T)this.constructor.newInstance(this.configDefault);
            }
            return (T)this.constructor.newInstance(keyConfig);
        }
        catch (Exception e) {
            logger.error("Failed to create client, exception: ", (Throwable)e);
            throw new MilvusClientException(ErrorCode.CLIENT_ERROR, (Throwable)e);
        }
    }

    public PooledObject<T> wrap(T client) {
        return new DefaultPooledObject(client);
    }

    public void destroyObject(String key, PooledObject<T> p) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.info("PoolClientFactory key: {} closes a client", (Object)key);
        }
        Object client = p.getObject();
        this.closeMethod.invoke(client, 3L);
    }

    public boolean validateObject(String key, PooledObject<T> p) {
        try {
            Object client = p.getObject();
            return (Boolean)this.verifyMethod.invoke(client, new Object[0]);
        }
        catch (Exception e) {
            logger.error("Failed to validate client, exception: ", (Throwable)e);
            throw new MilvusClientException(ErrorCode.CLIENT_ERROR, (Throwable)e);
        }
    }

    public void activateObject(String key, PooledObject<T> p) throws Exception {
        super.activateObject((Object)key, p);
    }

    public void passivateObject(String key, PooledObject<T> p) throws Exception {
        super.passivateObject((Object)key, p);
    }
}

