/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.role;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;

public class SelectGrantForRoleParam {
    private final String databaseName;
    private final String roleName;

    private SelectGrantForRoleParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Builder cannot be null");
        }
        this.databaseName = builder.databaseName;
        this.roleName = builder.roleName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String toString() {
        return "SelectGrantForRoleParam{databaseName='" + this.databaseName + '\'' + ", roleName='" + this.roleName + '\'' + '}';
    }

    public static final class Builder {
        private String databaseName;
        private String roleName;

        private Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withRoleName(String roleName) {
            if (roleName == null) {
                throw new IllegalArgumentException("Role name cannot be null");
            }
            this.roleName = roleName;
            return this;
        }

        public SelectGrantForRoleParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.roleName, "RoleName");
            return new SelectGrantForRoleParam(this);
        }
    }
}

