/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.resourcegroup;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;

public class TransferReplicaParam {
    private final String sourceGroupName;
    private final String targetGroupName;
    private final String collectionName;
    private final String databaseName;
    private final long replicaNumber;

    private TransferReplicaParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Builder cannot be null");
        }
        this.sourceGroupName = builder.sourceGroupName;
        this.targetGroupName = builder.targetGroupName;
        this.collectionName = builder.collectionName;
        this.databaseName = builder.databaseName;
        this.replicaNumber = builder.replicaNumber;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getSourceGroupName() {
        return this.sourceGroupName;
    }

    public String getTargetGroupName() {
        return this.targetGroupName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public long getReplicaNumber() {
        return this.replicaNumber;
    }

    public String toString() {
        return "TransferReplicaParam{sourceGroupName='" + this.sourceGroupName + '\'' + ", targetGroupName='" + this.targetGroupName + '\'' + ", collectionName='" + this.collectionName + '\'' + ", databaseName='" + this.databaseName + '\'' + ", replicaNumber=" + this.replicaNumber + '}';
    }

    public static final class Builder {
        private String sourceGroupName;
        private String targetGroupName;
        private String collectionName;
        private String databaseName;
        private Long replicaNumber = 0L;

        private Builder() {
        }

        public Builder withSourceGroupName(String groupName) {
            if (groupName == null) {
                throw new IllegalArgumentException("Source group name cannot be null");
            }
            this.sourceGroupName = groupName;
            return this;
        }

        public Builder withTargetGroupName(String groupName) {
            if (groupName == null) {
                throw new IllegalArgumentException("Target group name cannot be null");
            }
            this.targetGroupName = groupName;
            return this;
        }

        public Builder withCollectionName(String collectionName) {
            if (collectionName == null) {
                throw new IllegalArgumentException("Collection name cannot be null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withReplicaNumber(Long replicaNumber) {
            if (replicaNumber == null) {
                throw new IllegalArgumentException("Replica number cannot be null");
            }
            this.replicaNumber = replicaNumber;
            return this;
        }

        public TransferReplicaParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.sourceGroupName, "Source group name");
            ParamUtils.CheckNullEmptyString(this.targetGroupName, "Target group name");
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            if (this.replicaNumber <= 0L) {
                throw new ParamException("Replica number must be specified and greater than zero");
            }
            return new TransferReplicaParam(this);
        }
    }
}

