/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.dml.ranker;

import com.google.gson.JsonObject;
import io.milvus.exception.ParamException;
import io.milvus.param.dml.ranker.BaseRanker;
import java.util.HashMap;
import java.util.Map;

public class RRFRanker
extends BaseRanker {
    private final Integer k;

    private RRFRanker(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("builder cannot be null");
        }
        this.k = builder.k;
    }

    public Integer getK() {
        return this.k;
    }

    public String toString() {
        return "RRFRanker{k=" + this.k + '}';
    }

    @Override
    public Map<String, String> getProperties() {
        JsonObject params = new JsonObject();
        params.addProperty("k", (Number)this.k);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("strategy", "rrf");
        props.put("params", params.toString());
        return props;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Integer k = 60;

        private Builder() {
        }

        public Builder withK(Integer k) {
            if (k == null) {
                throw new IllegalArgumentException("k cannot be null");
            }
            this.k = k;
            return this;
        }

        public RRFRanker build() throws ParamException {
            if (this.k < 0) {
                throw new ParamException("K value cannot be negative");
            }
            return new RRFRanker(this);
        }
    }
}

