/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.credential;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;

public class CreateCredentialParam {
    private final String username;
    private final String password;

    private CreateCredentialParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("builder cannot be null");
        }
        this.username = builder.username;
        this.password = builder.password;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        return "CreateCredentialParam{username='" + this.username + '\'' + ", password='" + this.password + '\'' + '}';
    }

    public static final class Builder {
        private String username;
        private String password;

        private Builder() {
        }

        public Builder withUsername(String username) {
            if (username == null) {
                throw new IllegalArgumentException("username cannot be null");
            }
            this.username = username;
            return this;
        }

        public Builder withPassword(String password) {
            if (password == null) {
                throw new IllegalArgumentException("password cannot be null");
            }
            this.password = password;
            return this;
        }

        public CreateCredentialParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.username, "Username");
            ParamUtils.CheckNullEmptyString(this.password, "Password");
            return new CreateCredentialParam(this);
        }
    }
}

