/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.control;

import io.milvus.exception.ParamException;
import java.util.ArrayList;
import java.util.List;

public class LoadBalanceParam {
    private final String databaseName;
    private final String collectionName;
    private final Long srcNodeID;
    private final List<Long> destNodeIDs;
    private final List<Long> segmentIDs;

    private LoadBalanceParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("builder cannot be null");
        }
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.srcNodeID = builder.srcNodeID;
        this.destNodeIDs = builder.destNodeIDs;
        this.segmentIDs = builder.segmentIDs;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public Long getSrcNodeID() {
        return this.srcNodeID;
    }

    public List<Long> getDestNodeIDs() {
        return this.destNodeIDs;
    }

    public List<Long> getSegmentIDs() {
        return this.segmentIDs;
    }

    public String toString() {
        return "LoadBalanceParam{databaseName='" + this.databaseName + '\'' + ", collectionName='" + this.collectionName + '\'' + ", srcNodeID=" + this.srcNodeID + ", destNodeIDs=" + this.destNodeIDs + ", segmentIDs=" + this.segmentIDs + '}';
    }

    public static final class Builder {
        private String databaseName;
        private String collectionName;
        private final List<Long> destNodeIDs = new ArrayList<Long>();
        private final List<Long> segmentIDs = new ArrayList<Long>();
        private Long srcNodeID;

        private Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withCollectionName(String collectionName) {
            if (collectionName == null) {
                throw new IllegalArgumentException("collectionName cannot be null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withSourceNodeID(Long srcNodeID) {
            if (srcNodeID == null) {
                throw new IllegalArgumentException("srcNodeID cannot be null");
            }
            this.srcNodeID = srcNodeID;
            return this;
        }

        public Builder addDestinationNodeID(Long destNodeID) {
            if (destNodeID == null) {
                throw new IllegalArgumentException("destNodeID cannot be null");
            }
            if (!this.destNodeIDs.contains(destNodeID)) {
                this.destNodeIDs.add(destNodeID);
            }
            return this;
        }

        public Builder withDestinationNodeID(List<Long> destNodeIDs) {
            if (destNodeIDs == null) {
                throw new IllegalArgumentException("destNodeIDs cannot be null");
            }
            destNodeIDs.forEach(this::addDestinationNodeID);
            return this;
        }

        public Builder addSegmentID(Long segmentID) {
            if (segmentID == null) {
                throw new IllegalArgumentException("segmentID cannot be null");
            }
            if (!this.segmentIDs.contains(segmentID)) {
                this.segmentIDs.add(segmentID);
            }
            return this;
        }

        public Builder withSegmentIDs(List<Long> segmentIDs) {
            if (segmentIDs == null) {
                throw new IllegalArgumentException("segmentIDs cannot be null");
            }
            segmentIDs.forEach(this::addSegmentID);
            return this;
        }

        public LoadBalanceParam build() throws ParamException {
            if (this.segmentIDs.isEmpty()) {
                throw new ParamException("Sealed segment id array cannot be empty");
            }
            if (this.destNodeIDs.isEmpty()) {
                throw new ParamException("Destination query node id array cannot be empty");
            }
            return new LoadBalanceParam(this);
        }
    }
}

