/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.collection;

import io.milvus.exception.ParamException;
import io.milvus.grpc.DataType;
import io.milvus.param.ParamUtils;
import java.util.HashMap;
import java.util.Map;

public class FieldType {
    private final String name;
    private final boolean primaryKey;
    private final String description;
    private final DataType dataType;
    private final Map<String, String> typeParams;
    private final boolean autoID;
    private final boolean partitionKey;
    private final boolean clusteringKey;
    private final boolean isDynamic;
    private final DataType elementType;
    private final boolean nullable;
    private final Object defaultValue;

    private FieldType(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("builder cannot be null");
        }
        this.name = builder.name;
        this.primaryKey = builder.primaryKey;
        this.description = builder.description;
        this.dataType = builder.dataType;
        this.typeParams = builder.typeParams;
        this.autoID = builder.autoID;
        this.partitionKey = builder.partitionKey;
        this.clusteringKey = builder.clusteringKey;
        this.isDynamic = builder.isDynamic;
        this.elementType = builder.elementType;
        this.nullable = builder.nullable;
        this.defaultValue = builder.defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public String getDescription() {
        return this.description;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Map<String, String> getTypeParams() {
        return this.typeParams;
    }

    public boolean isAutoID() {
        return this.autoID;
    }

    public boolean isPartitionKey() {
        return this.partitionKey;
    }

    public boolean isClusteringKey() {
        return this.clusteringKey;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public DataType getElementType() {
        return this.elementType;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public int getDimension() {
        if (this.typeParams.containsKey("dim")) {
            return Integer.parseInt(this.typeParams.get("dim"));
        }
        return 0;
    }

    public int getMaxLength() {
        if (this.typeParams.containsKey("max_length")) {
            return Integer.parseInt(this.typeParams.get("max_length"));
        }
        return 0;
    }

    public int getMaxCapacity() {
        if (this.typeParams.containsKey("max_capacity")) {
            return Integer.parseInt(this.typeParams.get("max_capacity"));
        }
        return 0;
    }

    public String toString() {
        return "FieldType{name='" + this.name + '\'' + ", primaryKey=" + this.primaryKey + ", description='" + this.description + '\'' + ", dataType=" + (Object)((Object)this.dataType) + ", typeParams=" + this.typeParams + ", autoID=" + this.autoID + ", partitionKey=" + this.partitionKey + ", clusteringKey=" + this.clusteringKey + ", isDynamic=" + this.isDynamic + ", elementType=" + (Object)((Object)this.elementType) + ", nullable=" + this.nullable + ", defaultValue=" + this.defaultValue + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private boolean primaryKey = false;
        private String description = "";
        private DataType dataType;
        private final Map<String, String> typeParams = new HashMap<String, String>();
        private boolean autoID = false;
        private boolean partitionKey = false;
        private boolean clusteringKey = false;
        private boolean isDynamic = false;
        private DataType elementType = DataType.None;
        private boolean nullable = false;
        private Object defaultValue = null;
        private boolean enableDefaultValue = false;

        private Builder() {
        }

        public Builder withName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("name cannot be null");
            }
            this.name = name;
            return this;
        }

        public Builder withIsDynamic(boolean isDynamic) {
            this.isDynamic = isDynamic;
            return this;
        }

        public Builder withPrimaryKey(boolean primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public Builder withDescription(String description) {
            if (description == null) {
                throw new IllegalArgumentException("description cannot be null");
            }
            this.description = description;
            return this;
        }

        public Builder withDataType(DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException("dataType cannot be null");
            }
            this.dataType = dataType;
            return this;
        }

        public Builder withElementType(DataType elementType) {
            if (elementType == null) {
                throw new IllegalArgumentException("elementType cannot be null");
            }
            this.elementType = elementType;
            return this;
        }

        public Builder addTypeParam(String key, String value) {
            if (key == null) {
                throw new IllegalArgumentException("key cannot be null");
            }
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null");
            }
            this.typeParams.put(key, value);
            return this;
        }

        public Builder withTypeParams(Map<String, String> typeParams) {
            if (typeParams == null) {
                throw new IllegalArgumentException("typeParams cannot be null");
            }
            typeParams.forEach(this.typeParams::put);
            return this;
        }

        public Builder withDimension(Integer dimension) {
            if (dimension == null) {
                throw new IllegalArgumentException("dimension cannot be null");
            }
            this.typeParams.put("dim", dimension.toString());
            return this;
        }

        public Builder withMaxLength(Integer maxLength) {
            if (maxLength == null) {
                throw new IllegalArgumentException("maxLength cannot be null");
            }
            this.typeParams.put("max_length", maxLength.toString());
            return this;
        }

        public Builder withMaxCapacity(Integer maxCapacity) {
            if (maxCapacity == null) {
                throw new IllegalArgumentException("maxCapacity cannot be null");
            }
            if (maxCapacity <= 0 || maxCapacity > 4096) {
                throw new ParamException("Array field max capacity value must be within range [1, 4096]");
            }
            this.typeParams.put("max_capacity", maxCapacity.toString());
            return this;
        }

        public Builder withAutoID(boolean autoID) {
            this.autoID = autoID;
            return this;
        }

        public Builder withPartitionKey(boolean partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public Builder withNullable(boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        public Builder withDefaultValue(Object obj) {
            this.defaultValue = obj;
            this.enableDefaultValue = true;
            return this;
        }

        public Builder withClusteringKey(boolean clusteringKey) {
            this.clusteringKey = clusteringKey;
            return this;
        }

        public FieldType build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.name, "Field name");
            if (this.dataType == null || this.dataType == DataType.None || this.dataType == DataType.UNRECOGNIZED) {
                throw new ParamException("Field data type is illegal");
            }
            if (this.dataType == DataType.String) {
                throw new ParamException("String type is not supported, use Varchar instead");
            }
            if (ParamUtils.isVectorDataType(this.dataType) && this.dataType != DataType.SparseFloatVector) {
                if (!this.typeParams.containsKey("dim")) {
                    throw new ParamException("Vector field dimension must be specified");
                }
                try {
                    int dim = Integer.parseInt(this.typeParams.get("dim"));
                    if (dim <= 0) {
                        throw new ParamException("Vector field dimension must be larger than zero");
                    }
                }
                catch (NumberFormatException e) {
                    throw new ParamException("Vector field dimension must be an integer number");
                }
            }
            if (this.dataType == DataType.VarChar) {
                if (!this.typeParams.containsKey("max_length")) {
                    throw new ParamException("Varchar field max length must be specified");
                }
                try {
                    int len = Integer.parseInt(this.typeParams.get("max_length"));
                    if (len <= 0) {
                        throw new ParamException("Varchar field max length must be larger than zero");
                    }
                }
                catch (NumberFormatException e) {
                    throw new ParamException("Varchar field max length must be an integer number");
                }
            }
            if (this.partitionKey) {
                if (this.primaryKey) {
                    throw new ParamException("Primary key field can not be partition key");
                }
                if (this.dataType != DataType.Int64 && this.dataType != DataType.VarChar) {
                    throw new ParamException("Only Int64 and Varchar type field can be partition key");
                }
            }
            if (this.dataType == DataType.Array) {
                if (this.elementType == DataType.String) {
                    throw new ParamException("String type is not supported, use Varchar instead");
                }
                if (this.elementType == DataType.None || this.elementType == DataType.Array || this.elementType == DataType.JSON || ParamUtils.isVectorDataType(this.elementType) || this.elementType == DataType.UNRECOGNIZED) {
                    throw new ParamException("Unsupported element type");
                }
                if (!this.typeParams.containsKey("max_capacity")) {
                    throw new ParamException("Array field max capacity must be specified");
                }
                if (this.elementType == DataType.VarChar && !this.typeParams.containsKey("max_length")) {
                    throw new ParamException("Varchar array field max length must be specified");
                }
            }
            if (this.enableDefaultValue && this.defaultValue == null && !this.nullable) {
                String msg = String.format("Default value cannot be null for field '%s' that is defined as nullable == false.", this.name);
                throw new ParamException(msg);
            }
            return new FieldType(this);
        }
    }
}

