/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.alias;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;

public class DropAliasParam {
    private final String alias;
    private final String databaseName;

    private DropAliasParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("builder cannot be null");
        }
        this.alias = builder.alias;
        this.databaseName = builder.databaseName;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String toString() {
        return "DropAliasParam{alias='" + this.alias + '\'' + ", databaseName='" + this.databaseName + '\'' + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String alias;
        private String databaseName;

        private Builder() {
        }

        public Builder withAlias(String alias) {
            if (alias == null) {
                throw new IllegalArgumentException("alias cannot be null");
            }
            this.alias = alias;
            return this;
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public DropAliasParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.alias, "Alias");
            return new DropAliasParam(this);
        }
    }
}

