/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.vector.request.data;

import io.milvus.common.utils.Float16Utils;
import io.milvus.grpc.PlaceholderType;
import io.milvus.v2.service.vector.request.data.BaseVector;
import java.nio.ByteBuffer;
import java.util.List;

public class Float16Vec
implements BaseVector {
    private final ByteBuffer data;

    public Float16Vec(ByteBuffer data) {
        this.data = data;
    }

    public Float16Vec(byte[] data) {
        this.data = ByteBuffer.wrap(data);
    }

    public Float16Vec(List<Float> data) {
        this.data = Float16Utils.f32VectorToFp16Buffer(data);
    }

    @Override
    public PlaceholderType getPlaceholderType() {
        return PlaceholderType.Float16Vector;
    }

    @Override
    public Object getData() {
        return this.data;
    }
}

