/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.index.response;

import io.milvus.v2.common.IndexBuildState;
import io.milvus.v2.common.IndexParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DescribeIndexResp {
    private List<IndexDesc> indexDescriptions;

    private DescribeIndexResp(DescribeIndexRespBuilder builder) {
        this.indexDescriptions = builder.indexDescriptions;
    }

    public List<IndexDesc> getIndexDescriptions() {
        return this.indexDescriptions;
    }

    public void setIndexDescriptions(List<IndexDesc> indexDescriptions) {
        this.indexDescriptions = indexDescriptions;
    }

    public IndexDesc getIndexDescByFieldName(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        for (IndexDesc desc : this.indexDescriptions) {
            if (!desc.getFieldName().equals(fieldName)) continue;
            return desc;
        }
        return null;
    }

    public IndexDesc getIndexDescByIndexName(String indexName) {
        if (indexName == null) {
            throw new IllegalArgumentException("Index name cannot be null");
        }
        for (IndexDesc desc : this.indexDescriptions) {
            if (!desc.getIndexName().equals(indexName)) continue;
            return desc;
        }
        return null;
    }

    public String toString() {
        return "DescribeIndexResp{indexDescriptions=" + this.indexDescriptions + '}';
    }

    public static DescribeIndexRespBuilder builder() {
        return new DescribeIndexRespBuilder();
    }

    public static final class IndexDesc {
        private String fieldName;
        private String indexName;
        private long id;
        private IndexParam.IndexType indexType;
        private IndexParam.MetricType metricType;
        private Map<String, String> extraParams;
        private long indexedRows;
        private long totalRows;
        private long pendingIndexRows;
        private IndexBuildState indexState;
        private String indexFailedReason;
        @Deprecated
        private Map<String, String> properties;

        private IndexDesc(IndexDescBuilder builder) {
            this.fieldName = builder.fieldName;
            this.indexName = builder.indexName;
            this.id = builder.id;
            this.indexType = builder.indexType;
            this.metricType = builder.metricType;
            this.extraParams = builder.extraParams;
            this.indexedRows = builder.indexedRows;
            this.totalRows = builder.totalRows;
            this.pendingIndexRows = builder.pendingIndexRows;
            this.indexState = builder.indexState;
            this.indexFailedReason = builder.indexFailedReason;
            this.properties = builder.properties;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getIndexName() {
            return this.indexName;
        }

        public void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public IndexParam.IndexType getIndexType() {
            return this.indexType;
        }

        public void setIndexType(IndexParam.IndexType indexType) {
            this.indexType = indexType;
        }

        public IndexParam.MetricType getMetricType() {
            return this.metricType;
        }

        public void setMetricType(IndexParam.MetricType metricType) {
            this.metricType = metricType;
        }

        public Map<String, String> getExtraParams() {
            return this.extraParams;
        }

        public void setExtraParams(Map<String, String> extraParams) {
            this.extraParams = extraParams;
        }

        public long getIndexedRows() {
            return this.indexedRows;
        }

        public void setIndexedRows(long indexedRows) {
            this.indexedRows = indexedRows;
        }

        public long getTotalRows() {
            return this.totalRows;
        }

        public void setTotalRows(long totalRows) {
            this.totalRows = totalRows;
        }

        public long getPendingIndexRows() {
            return this.pendingIndexRows;
        }

        public void setPendingIndexRows(long pendingIndexRows) {
            this.pendingIndexRows = pendingIndexRows;
        }

        public IndexBuildState getIndexState() {
            return this.indexState;
        }

        public void setIndexState(IndexBuildState indexState) {
            this.indexState = indexState;
        }

        public String getIndexFailedReason() {
            return this.indexFailedReason;
        }

        public void setIndexFailedReason(String indexFailedReason) {
            this.indexFailedReason = indexFailedReason;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }

        public String toString() {
            return "IndexDesc{fieldName='" + this.fieldName + '\'' + ", indexName='" + this.indexName + '\'' + ", id=" + this.id + ", indexType=" + (Object)((Object)this.indexType) + ", metricType=" + (Object)((Object)this.metricType) + ", extraParams=" + this.extraParams + ", indexedRows=" + this.indexedRows + ", totalRows=" + this.totalRows + ", pendingIndexRows=" + this.pendingIndexRows + ", indexState=" + (Object)((Object)this.indexState) + ", indexFailedReason='" + this.indexFailedReason + '\'' + ", properties=" + this.properties + '}';
        }

        public static IndexDescBuilder builder() {
            return new IndexDescBuilder();
        }

        public static class IndexDescBuilder {
            private String fieldName;
            private String indexName;
            private long id;
            private IndexParam.IndexType indexType = IndexParam.IndexType.None;
            private IndexParam.MetricType metricType = IndexParam.MetricType.INVALID;
            private Map<String, String> extraParams = new HashMap<String, String>();
            private long indexedRows = 0L;
            private long totalRows = 0L;
            private long pendingIndexRows = 0L;
            private IndexBuildState indexState = IndexBuildState.IndexStateNone;
            private String indexFailedReason = "";
            private Map<String, String> properties = new HashMap<String, String>();

            private IndexDescBuilder() {
            }

            public IndexDescBuilder fieldName(String fieldName) {
                this.fieldName = fieldName;
                return this;
            }

            public IndexDescBuilder indexName(String indexName) {
                this.indexName = indexName;
                return this;
            }

            public IndexDescBuilder id(long id) {
                this.id = id;
                return this;
            }

            public IndexDescBuilder indexType(IndexParam.IndexType indexType) {
                this.indexType = indexType;
                return this;
            }

            public IndexDescBuilder metricType(IndexParam.MetricType metricType) {
                this.metricType = metricType;
                return this;
            }

            public IndexDescBuilder extraParams(Map<String, String> extraParams) {
                this.extraParams = extraParams;
                return this;
            }

            public IndexDescBuilder indexedRows(long indexedRows) {
                this.indexedRows = indexedRows;
                return this;
            }

            public IndexDescBuilder totalRows(long totalRows) {
                this.totalRows = totalRows;
                return this;
            }

            public IndexDescBuilder pendingIndexRows(long pendingIndexRows) {
                this.pendingIndexRows = pendingIndexRows;
                return this;
            }

            public IndexDescBuilder indexState(IndexBuildState indexState) {
                this.indexState = indexState;
                return this;
            }

            public IndexDescBuilder indexFailedReason(String indexFailedReason) {
                this.indexFailedReason = indexFailedReason;
                return this;
            }

            public IndexDescBuilder properties(Map<String, String> properties) {
                this.properties = properties;
                return this;
            }

            public IndexDesc build() {
                return new IndexDesc(this);
            }
        }
    }

    public static class DescribeIndexRespBuilder {
        private List<IndexDesc> indexDescriptions = new ArrayList<IndexDesc>();

        private DescribeIndexRespBuilder() {
        }

        public DescribeIndexRespBuilder indexDescriptions(List<IndexDesc> indexDescriptions) {
            this.indexDescriptions = indexDescriptions;
            return this;
        }

        public DescribeIndexResp build() {
            return new DescribeIndexResp(this);
        }
    }
}

