/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.collection.request;

import io.milvus.v2.common.DataType;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import io.milvus.v2.utils.SchemaUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AddFieldReq {
    private String fieldName;
    private String description;
    private DataType dataType;
    private Integer maxLength;
    private Boolean isPrimaryKey;
    private Boolean isPartitionKey;
    private Boolean isClusteringKey;
    private Boolean autoID;
    private Integer dimension;
    private DataType elementType;
    private Integer maxCapacity;
    private Boolean isNullable;
    private Object defaultValue;
    private boolean enableDefaultValue;
    private Boolean enableAnalyzer;
    private Map<String, Object> analyzerParams;
    private Boolean enableMatch;
    private Map<String, String> typeParams;
    private Map<String, Object> multiAnalyzerParams;
    private List<CreateCollectionReq.FieldSchema> structFields;

    AddFieldReq(AddFieldReqBuilder<?> builder) {
        this.fieldName = ((AddFieldReqBuilder)builder).fieldName;
        this.description = ((AddFieldReqBuilder)builder).description != null ? ((AddFieldReqBuilder)builder).description : "";
        this.dataType = ((AddFieldReqBuilder)builder).dataType;
        this.maxLength = ((AddFieldReqBuilder)builder).maxLength != null ? ((AddFieldReqBuilder)builder).maxLength : 65535;
        this.isPrimaryKey = ((AddFieldReqBuilder)builder).isPrimaryKey != null ? ((AddFieldReqBuilder)builder).isPrimaryKey : Boolean.FALSE;
        this.isPartitionKey = ((AddFieldReqBuilder)builder).isPartitionKey != null ? ((AddFieldReqBuilder)builder).isPartitionKey : Boolean.FALSE;
        this.isClusteringKey = ((AddFieldReqBuilder)builder).isClusteringKey != null ? ((AddFieldReqBuilder)builder).isClusteringKey : Boolean.FALSE;
        this.autoID = ((AddFieldReqBuilder)builder).autoID != null ? ((AddFieldReqBuilder)builder).autoID : Boolean.FALSE;
        this.dimension = ((AddFieldReqBuilder)builder).dimension;
        this.elementType = ((AddFieldReqBuilder)builder).elementType;
        this.maxCapacity = ((AddFieldReqBuilder)builder).maxCapacity;
        this.isNullable = ((AddFieldReqBuilder)builder).isNullable != null ? ((AddFieldReqBuilder)builder).isNullable : Boolean.FALSE;
        this.defaultValue = ((AddFieldReqBuilder)builder).defaultValue;
        this.enableDefaultValue = ((AddFieldReqBuilder)builder).enableDefaultValue;
        this.enableAnalyzer = ((AddFieldReqBuilder)builder).enableAnalyzer;
        this.analyzerParams = ((AddFieldReqBuilder)builder).analyzerParams;
        this.enableMatch = ((AddFieldReqBuilder)builder).enableMatch;
        this.typeParams = ((AddFieldReqBuilder)builder).typeParams;
        this.multiAnalyzerParams = ((AddFieldReqBuilder)builder).multiAnalyzerParams;
        this.structFields = ((AddFieldReqBuilder)builder).structFields != null ? ((AddFieldReqBuilder)builder).structFields : new ArrayList();
    }

    public static AddFieldReqBuilder<?> builder() {
        return new AddFieldReqBuilder();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getDescription() {
        return this.description;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Boolean getIsPrimaryKey() {
        return this.isPrimaryKey;
    }

    public Boolean getIsPartitionKey() {
        return this.isPartitionKey;
    }

    public Boolean getIsClusteringKey() {
        return this.isClusteringKey;
    }

    public Boolean getAutoID() {
        return this.autoID;
    }

    public Integer getDimension() {
        return this.dimension;
    }

    public DataType getElementType() {
        return this.elementType;
    }

    public Integer getMaxCapacity() {
        return this.maxCapacity;
    }

    public Boolean getIsNullable() {
        return this.isNullable;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isEnableDefaultValue() {
        return this.enableDefaultValue;
    }

    public Boolean getEnableAnalyzer() {
        return this.enableAnalyzer;
    }

    public Map<String, Object> getAnalyzerParams() {
        return this.analyzerParams;
    }

    public Boolean getEnableMatch() {
        return this.enableMatch;
    }

    public Map<String, String> getTypeParams() {
        return this.typeParams;
    }

    public Map<String, Object> getMultiAnalyzerParams() {
        return this.multiAnalyzerParams;
    }

    public List<CreateCollectionReq.FieldSchema> getStructFields() {
        return this.structFields;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public void setIsPrimaryKey(Boolean isPrimaryKey) {
        this.isPrimaryKey = isPrimaryKey;
    }

    public void setIsPartitionKey(Boolean isPartitionKey) {
        this.isPartitionKey = isPartitionKey;
    }

    public void setIsClusteringKey(Boolean isClusteringKey) {
        this.isClusteringKey = isClusteringKey;
    }

    public void setAutoID(Boolean autoID) {
        this.autoID = autoID;
    }

    public void setDimension(Integer dimension) {
        this.dimension = dimension;
    }

    public void setElementType(DataType elementType) {
        this.elementType = elementType;
    }

    public void setMaxCapacity(Integer maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public void setIsNullable(Boolean isNullable) {
        this.isNullable = isNullable;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setEnableDefaultValue(boolean enableDefaultValue) {
        this.enableDefaultValue = enableDefaultValue;
    }

    public void setEnableAnalyzer(Boolean enableAnalyzer) {
        this.enableAnalyzer = enableAnalyzer;
    }

    public void setAnalyzerParams(Map<String, Object> analyzerParams) {
        this.analyzerParams = analyzerParams;
    }

    public void setEnableMatch(Boolean enableMatch) {
        this.enableMatch = enableMatch;
    }

    public void setTypeParams(Map<String, String> typeParams) {
        this.typeParams = typeParams;
    }

    public void setMultiAnalyzerParams(Map<String, Object> multiAnalyzerParams) {
        this.multiAnalyzerParams = multiAnalyzerParams;
    }

    public void setStructFields(List<CreateCollectionReq.FieldSchema> structFields) {
        this.structFields = structFields;
    }

    public String toString() {
        return "AddFieldReq{fieldName='" + this.fieldName + '\'' + ", description='" + this.description + '\'' + ", dataType=" + (Object)((Object)this.dataType) + ", maxLength=" + this.maxLength + ", isPrimaryKey=" + this.isPrimaryKey + ", isPartitionKey=" + this.isPartitionKey + ", isClusteringKey=" + this.isClusteringKey + ", autoID=" + this.autoID + ", dimension=" + this.dimension + ", elementType=" + (Object)((Object)this.elementType) + ", maxCapacity=" + this.maxCapacity + ", isNullable=" + this.isNullable + ", defaultValue=" + this.defaultValue + ", enableDefaultValue=" + this.enableDefaultValue + ", enableAnalyzer=" + this.enableAnalyzer + ", analyzerParams=" + this.analyzerParams + ", enableMatch=" + this.enableMatch + ", typeParams=" + this.typeParams + ", multiAnalyzerParams=" + this.multiAnalyzerParams + ", structFields=" + this.structFields + '}';
    }

    public static class AddFieldReqBuilder<T extends AddFieldReqBuilder<T>> {
        private String fieldName;
        private String description;
        private DataType dataType;
        private Integer maxLength;
        private Boolean isPrimaryKey;
        private Boolean isPartitionKey;
        private Boolean isClusteringKey;
        private Boolean autoID;
        private Integer dimension;
        private DataType elementType;
        private Integer maxCapacity;
        private Boolean isNullable;
        private Object defaultValue;
        private boolean enableDefaultValue = false;
        private Boolean enableAnalyzer;
        private Map<String, Object> analyzerParams;
        private Boolean enableMatch;
        private Map<String, String> typeParams;
        private Map<String, Object> multiAnalyzerParams;
        private List<CreateCollectionReq.FieldSchema> structFields;

        public T fieldName(String fieldName) {
            this.fieldName = fieldName;
            return (T)this;
        }

        public T description(String description) {
            this.description = description;
            return (T)this;
        }

        public T dataType(DataType dataType) {
            this.dataType = dataType;
            return (T)this;
        }

        public T maxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return (T)this;
        }

        public T isPrimaryKey(Boolean isPrimaryKey) {
            this.isPrimaryKey = isPrimaryKey;
            return (T)this;
        }

        public T isPartitionKey(Boolean isPartitionKey) {
            this.isPartitionKey = isPartitionKey;
            return (T)this;
        }

        public T isClusteringKey(Boolean isClusteringKey) {
            this.isClusteringKey = isClusteringKey;
            return (T)this;
        }

        public T autoID(Boolean autoID) {
            this.autoID = autoID;
            return (T)this;
        }

        public T dimension(Integer dimension) {
            this.dimension = dimension;
            return (T)this;
        }

        public T elementType(DataType elementType) {
            this.elementType = elementType;
            return (T)this;
        }

        public T maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return (T)this;
        }

        public T isNullable(Boolean isNullable) {
            this.isNullable = isNullable;
            return (T)this;
        }

        public T defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            this.enableDefaultValue = true;
            return (T)this;
        }

        public T enableDefaultValue(boolean enableDefaultValue) {
            this.enableDefaultValue = enableDefaultValue;
            return (T)this;
        }

        public T enableAnalyzer(Boolean enableAnalyzer) {
            this.enableAnalyzer = enableAnalyzer;
            return (T)this;
        }

        public T analyzerParams(Map<String, Object> analyzerParams) {
            this.analyzerParams = analyzerParams;
            return (T)this;
        }

        public T enableMatch(Boolean enableMatch) {
            this.enableMatch = enableMatch;
            return (T)this;
        }

        public T typeParams(Map<String, String> typeParams) {
            this.typeParams = typeParams;
            return (T)this;
        }

        public T multiAnalyzerParams(Map<String, Object> multiAnalyzerParams) {
            this.multiAnalyzerParams = multiAnalyzerParams;
            return (T)this;
        }

        public T structFields(List<CreateCollectionReq.FieldSchema> structFields) {
            this.structFields = structFields;
            return (T)this;
        }

        public T addStructField(AddFieldReq addFieldReq) {
            if (this.structFields == null) {
                this.structFields = new ArrayList<CreateCollectionReq.FieldSchema>();
            }
            CreateCollectionReq.FieldSchema field = SchemaUtils.convertFieldReqToFieldSchema(addFieldReq);
            this.structFields.add(field);
            return (T)this;
        }

        public AddFieldReq build() {
            return new AddFieldReq(this);
        }
    }
}

