/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.response;

import com.google.gson.reflect.TypeToken;
import io.milvus.common.utils.JsonUtils;
import io.milvus.grpc.DescribeIndexResponse;
import io.milvus.grpc.IndexDescription;
import io.milvus.param.IndexBuildState;
import io.milvus.param.IndexType;
import io.milvus.param.MetricType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DescIndexResponseWrapper {
    private final DescribeIndexResponse response;

    public DescIndexResponseWrapper(DescribeIndexResponse response) {
        if (response == null) {
            throw new IllegalArgumentException("DescribeIndexResponse cannot be null");
        }
        this.response = response;
    }

    public List<IndexDesc> getIndexDescriptions() {
        ArrayList<IndexDesc> results = new ArrayList<IndexDesc>();
        List<IndexDescription> descriptions = this.response.getIndexDescriptionsList();
        descriptions.forEach(desc -> {
            IndexDesc res = this.convertIndexDescInternal((IndexDescription)desc);
            results.add(res);
        });
        return results;
    }

    public IndexDesc getIndexDescByFieldName(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        for (IndexDescription desc : this.response.getIndexDescriptionsList()) {
            if (fieldName.compareTo(desc.getFieldName()) != 0) continue;
            return this.convertIndexDescInternal(desc);
        }
        return null;
    }

    public IndexDesc getIndexDescByIndexName(String indexName) {
        if (indexName == null) {
            throw new IllegalArgumentException("Index name cannot be null");
        }
        for (IndexDescription desc : this.response.getIndexDescriptionsList()) {
            if (indexName.compareTo(desc.getIndexName()) != 0) continue;
            return this.convertIndexDescInternal(desc);
        }
        return null;
    }

    private IndexDesc convertIndexDescInternal(IndexDescription desc) {
        IndexDesc res = new IndexDesc(desc.getFieldName(), desc.getIndexName(), desc.getIndexID());
        res.indexedRows = desc.getIndexedRows();
        res.totalRows = desc.getTotalRows();
        res.pendingIndexRows = desc.getPendingIndexRows();
        res.indexState = IndexBuildState.valueOf(desc.getState().name());
        res.indexFailedReason = desc.getIndexStateFailReason();
        desc.getParamsList().forEach(kv -> res.addParam(kv.getKey(), kv.getValue()));
        return res;
    }

    public static final class IndexDesc {
        private final String fieldName;
        private final String indexName;
        private final long id;
        private final Map<String, String> params = new HashMap<String, String>();
        long indexedRows = 0L;
        long totalRows = 0L;
        long pendingIndexRows = 0L;
        private IndexBuildState indexState = IndexBuildState.IndexStateNone;
        String indexFailedReason = "";

        public IndexDesc(String fieldName, String indexName, long id) {
            if (fieldName == null) {
                throw new IllegalArgumentException("Field name cannot be null");
            }
            if (indexName == null) {
                throw new IllegalArgumentException("Index name cannot be null");
            }
            this.fieldName = fieldName;
            this.indexName = indexName;
            this.id = id;
        }

        public void addParam(String key, String value) {
            if (key == null) {
                throw new IllegalArgumentException("Key cannot be null");
            }
            if (value == null) {
                throw new IllegalArgumentException("Value cannot be null");
            }
            this.params.put(key, value);
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getIndexName() {
            return this.indexName;
        }

        public long getId() {
            return this.id;
        }

        public Map<String, String> getParams() {
            return this.params;
        }

        public long getIndexedRows() {
            return this.indexedRows;
        }

        public long getTotalRows() {
            return this.totalRows;
        }

        public long getPendingIndexRows() {
            return this.pendingIndexRows;
        }

        public IndexBuildState getIndexState() {
            return this.indexState;
        }

        public String getIndexFailedReason() {
            return this.indexFailedReason;
        }

        public IndexType getIndexType() {
            if (this.params.containsKey("index_type")) {
                return IndexType.valueOf(this.params.get("index_type").toUpperCase());
            }
            return IndexType.None;
        }

        public MetricType getMetricType() {
            if (this.params.containsKey("metric_type")) {
                return MetricType.valueOf(this.params.get("metric_type"));
            }
            return MetricType.None;
        }

        public String getExtraParam() {
            HashMap<String, String> extraParams = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : this.params.entrySet()) {
                if (entry.getKey().equals("index_type") || entry.getKey().equals("metric_type")) continue;
                if (entry.getKey().equals("params")) {
                    Map tempParams = (Map)JsonUtils.fromJson(entry.getValue(), new TypeToken<Map<String, String>>(){}.getType());
                    extraParams.putAll(tempParams);
                    continue;
                }
                extraParams.put(entry.getKey(), entry.getValue());
            }
            return JsonUtils.toJson(extraParams);
        }

        public String toString() {
            return "IndexDesc{fieldName='" + this.fieldName + '\'' + ", indexName='" + this.indexName + '\'' + ", id=" + this.id + ", params=" + this.params + ", indexedRows=" + this.indexedRows + ", totalRows=" + this.totalRows + ", pendingIndexRows=" + this.pendingIndexRows + ", indexState=" + (Object)((Object)this.indexState) + ", indexFailedReason='" + this.indexFailedReason + '\'' + '}';
        }
    }
}

