/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.response;

import io.milvus.common.clientenum.ConsistencyLevelEnum;
import io.milvus.exception.ParamException;
import io.milvus.grpc.CollectionSchema;
import io.milvus.grpc.DescribeCollectionResponse;
import io.milvus.grpc.FieldSchema;
import io.milvus.param.ParamUtils;
import io.milvus.param.collection.CollectionSchemaParam;
import io.milvus.param.collection.FieldType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DescCollResponseWrapper {
    private final DescribeCollectionResponse response;
    Map<String, String> pairs = new HashMap<String, String>();

    public DescCollResponseWrapper(DescribeCollectionResponse response) {
        if (response == null) {
            throw new IllegalArgumentException("Response cannot be null");
        }
        this.response = response;
        response.getPropertiesList().forEach(prop -> this.pairs.put(prop.getKey(), prop.getValue()));
    }

    public String getCollectionName() {
        CollectionSchema schema = this.response.getSchema();
        return schema.getName();
    }

    public String getDatabaseName() {
        return this.response.getDbName();
    }

    public String getCollectionDescription() {
        CollectionSchema schema = this.response.getSchema();
        return schema.getDescription();
    }

    public long getCollectionID() {
        return this.response.getCollectionID();
    }

    public int getShardNumber() {
        return this.response.getShardsNum();
    }

    public ConsistencyLevelEnum getConsistencyLevel() {
        return ConsistencyLevelEnum.valueOf(this.response.getConsistencyLevel().name().toUpperCase());
    }

    public long getCreatedUtcTimestamp() {
        return this.response.getCreatedUtcTimestamp();
    }

    public List<String> getAliases() {
        ArrayList<String> aliases = new ArrayList<String>();
        for (int i = 0; i < this.response.getAliasesCount(); ++i) {
            aliases.add(this.response.getAliases(i));
        }
        return aliases;
    }

    public List<FieldType> getFields() {
        ArrayList<FieldType> results = new ArrayList<FieldType>();
        CollectionSchema schema = this.response.getSchema();
        List<FieldSchema> fields = schema.getFieldsList();
        fields.forEach(field -> results.add(ParamUtils.ConvertField(field)));
        return results;
    }

    public FieldType getFieldByName(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        CollectionSchema schema = this.response.getSchema();
        for (int i = 0; i < schema.getFieldsCount(); ++i) {
            FieldSchema field = schema.getFields(i);
            if (fieldName.compareTo(field.getName()) != 0) continue;
            return ParamUtils.ConvertField(field);
        }
        return null;
    }

    @Deprecated
    public boolean getEnableDynamicField() {
        CollectionSchema schema = this.response.getSchema();
        return schema.getEnableDynamicField();
    }

    public boolean isDynamicFieldEnabled() {
        CollectionSchema schema = this.response.getSchema();
        return schema.getEnableDynamicField();
    }

    public FieldType getPartitionKeyField() {
        CollectionSchema schema = this.response.getSchema();
        for (int i = 0; i < schema.getFieldsCount(); ++i) {
            FieldSchema field = schema.getFields(i);
            if (!field.getIsPartitionKey()) continue;
            return ParamUtils.ConvertField(field);
        }
        return null;
    }

    public FieldType getPrimaryField() {
        CollectionSchema schema = this.response.getSchema();
        for (int i = 0; i < schema.getFieldsCount(); ++i) {
            FieldSchema field = schema.getFields(i);
            if (!field.getIsPrimaryKey()) continue;
            return ParamUtils.ConvertField(field);
        }
        throw new ParamException("No primary key found.");
    }

    @Deprecated
    public FieldType getVectorField() {
        CollectionSchema schema = this.response.getSchema();
        for (int i = 0; i < schema.getFieldsCount(); ++i) {
            FieldSchema field = schema.getFields(i);
            if (!ParamUtils.isVectorDataType(field.getDataType())) continue;
            return ParamUtils.ConvertField(field);
        }
        throw new ParamException("No vector key found.");
    }

    public List<FieldType> getVectorFields() {
        ArrayList<FieldType> vectorFields = new ArrayList<FieldType>();
        CollectionSchema schema = this.response.getSchema();
        for (int i = 0; i < schema.getFieldsCount(); ++i) {
            FieldSchema field = schema.getFields(i);
            if (!ParamUtils.isVectorDataType(field.getDataType())) continue;
            vectorFields.add(ParamUtils.ConvertField(field));
        }
        return vectorFields;
    }

    public Map<String, String> getProperties() {
        return this.pairs;
    }

    public CollectionSchemaParam getSchema() {
        return CollectionSchemaParam.newBuilder().withFieldTypes(this.getFields()).withEnableDynamicField(this.isDynamicFieldEnabled()).build();
    }

    public List<String> getResourceGroups() {
        String value = this.pairs.get("collection.resource_groups");
        if (value == null) {
            return new ArrayList<String>();
        }
        return Arrays.asList(value.split(","));
    }

    public int getReplicaNumber() {
        String value = this.pairs.get("collection.replica.number");
        if (value == null) {
            return 0;
        }
        return Integer.parseInt(this.pairs.get("collection.replica.number"));
    }

    public String toString() {
        return "Collection Description{name:'" + this.getCollectionName() + '\'' + ", databaseName:'" + this.getDatabaseName() + '\'' + ", description:'" + this.getCollectionDescription() + '\'' + ", id:" + this.getCollectionID() + ", shardNumber:" + this.getShardNumber() + ", createdUtcTimestamp:" + this.getCreatedUtcTimestamp() + ", aliases:" + this.getAliases().toString() + ", fields:" + this.getFields().toString() + ", isDynamicFieldEnabled:" + this.isDynamicFieldEnabled() + ", consistencyLevel:" + this.getConsistencyLevel().name() + ", properties:" + this.getProperties() + '}';
    }
}

