/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.role;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;

public class AddUserToRoleParam {
    private final String userName;
    private final String roleName;

    private AddUserToRoleParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Builder cannot be null");
        }
        this.userName = builder.userName;
        this.roleName = builder.roleName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getUserName() {
        return this.userName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String toString() {
        return "AddUserToRoleParam{userName='" + this.userName + '\'' + ", roleName='" + this.roleName + '\'' + '}';
    }

    public static final class Builder {
        private String userName;
        private String roleName;

        private Builder() {
        }

        public Builder withUserName(String userName) {
            if (userName == null) {
                throw new IllegalArgumentException("User name cannot be null");
            }
            this.userName = userName;
            return this;
        }

        public Builder withRoleName(String roleName) {
            if (roleName == null) {
                throw new IllegalArgumentException("Role name cannot be null");
            }
            this.roleName = roleName;
            return this;
        }

        public AddUserToRoleParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.userName, "UserName");
            ParamUtils.CheckNullEmptyString(this.roleName, "RoleName");
            return new AddUserToRoleParam(this);
        }
    }
}

