/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.resourcegroup;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;

public class TransferNodeParam {
    private final String sourceGroupName;
    private final String targetGroupName;
    private final int nodeNumber;

    private TransferNodeParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Builder cannot be null");
        }
        this.sourceGroupName = builder.sourceGroupName;
        this.targetGroupName = builder.targetGroupName;
        this.nodeNumber = builder.nodeNumber;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getSourceGroupName() {
        return this.sourceGroupName;
    }

    public String getTargetGroupName() {
        return this.targetGroupName;
    }

    public int getNodeNumber() {
        return this.nodeNumber;
    }

    public String toString() {
        return "TransferNodeParam{sourceGroupName='" + this.sourceGroupName + '\'' + ", targetGroupName='" + this.targetGroupName + '\'' + ", nodeNumber=" + this.nodeNumber + '}';
    }

    public static final class Builder {
        private String sourceGroupName;
        private String targetGroupName;
        private Integer nodeNumber;

        private Builder() {
        }

        public Builder withSourceGroupName(String groupName) {
            if (groupName == null) {
                throw new IllegalArgumentException("Source group name cannot be null");
            }
            this.sourceGroupName = groupName;
            return this;
        }

        public Builder withTargetGroupName(String groupName) {
            if (groupName == null) {
                throw new IllegalArgumentException("Target group name cannot be null");
            }
            this.targetGroupName = groupName;
            return this;
        }

        public Builder withNodeNumber(Integer nodeNumber) {
            if (nodeNumber == null) {
                throw new IllegalArgumentException("Node number cannot be null");
            }
            this.nodeNumber = nodeNumber;
            return this;
        }

        public TransferNodeParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.sourceGroupName, "Source group name");
            ParamUtils.CheckNullEmptyString(this.targetGroupName, "Target group name");
            return new TransferNodeParam(this);
        }
    }
}

