/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.partition;

import io.milvus.exception.ParamException;
import io.milvus.grpc.ShowType;
import io.milvus.param.ParamUtils;
import java.util.ArrayList;
import java.util.List;

public class ShowPartitionsParam {
    private final String databaseName;
    private final String collectionName;
    private final List<String> partitionNames;
    private final ShowType showType;

    private ShowPartitionsParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("builder cannot be null");
        }
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.partitionNames = builder.partitionNames;
        this.showType = builder.showType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public List<String> getPartitionNames() {
        return this.partitionNames;
    }

    public ShowType getShowType() {
        return this.showType;
    }

    public String toString() {
        return "ShowPartitionsParam{databaseName='" + this.databaseName + '\'' + ", collectionName='" + this.collectionName + '\'' + ", partitionNames=" + this.partitionNames + ", showType=" + (Object)((Object)this.showType) + '}';
    }

    public static final class Builder {
        private String databaseName;
        private String collectionName;
        private final List<String> partitionNames = new ArrayList<String>();
        private ShowType showType = ShowType.All;

        private Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withCollectionName(String collectionName) {
            if (collectionName == null) {
                throw new IllegalArgumentException("collectionName cannot be null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withPartitionNames(List<String> partitionNames) {
            if (partitionNames == null) {
                throw new IllegalArgumentException("partitionNames cannot be null");
            }
            partitionNames.forEach(this::addPartitionName);
            return this;
        }

        public Builder addPartitionName(String partitionName) {
            if (partitionName == null) {
                throw new IllegalArgumentException("partitionName cannot be null");
            }
            if (!this.partitionNames.contains(partitionName)) {
                this.partitionNames.add(partitionName);
            }
            return this;
        }

        public ShowPartitionsParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            if (!this.partitionNames.isEmpty()) {
                for (String partitionName : this.partitionNames) {
                    ParamUtils.CheckNullEmptyString(partitionName, "Partition name");
                }
                this.showType = ShowType.InMemory;
            }
            return new ShowPartitionsParam(this);
        }
    }
}

