/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.dml;

import com.google.common.collect.Lists;
import io.milvus.common.clientenum.ConsistencyLevelEnum;
import io.milvus.exception.ParamException;
import io.milvus.param.Constant;
import io.milvus.param.ParamUtils;
import java.util.ArrayList;
import java.util.List;

public class QueryParam {
    private String databaseName;
    private final String collectionName;
    private final List<String> partitionNames;
    private final List<String> outFields;
    private final String expr;
    private final long travelTimestamp;
    private final long guaranteeTimestamp;
    private final long gracefulTime;
    private final ConsistencyLevelEnum consistencyLevel;
    private final long offset;
    private final long limit;
    private final boolean ignoreGrowing;

    private QueryParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("builder cannot be null");
        }
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.partitionNames = builder.partitionNames;
        this.outFields = builder.outFields;
        this.expr = builder.expr;
        this.travelTimestamp = builder.travelTimestamp;
        this.guaranteeTimestamp = builder.guaranteeTimestamp;
        this.consistencyLevel = builder.consistencyLevel;
        this.gracefulTime = builder.gracefulTime;
        this.offset = builder.offset;
        this.limit = builder.limit;
        this.ignoreGrowing = builder.ignoreGrowing;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public List<String> getPartitionNames() {
        return this.partitionNames;
    }

    public List<String> getOutFields() {
        return this.outFields;
    }

    public String getExpr() {
        return this.expr;
    }

    public long getTravelTimestamp() {
        return this.travelTimestamp;
    }

    public long getGuaranteeTimestamp() {
        return this.guaranteeTimestamp;
    }

    public long getGracefulTime() {
        return this.gracefulTime;
    }

    public ConsistencyLevelEnum getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLimit() {
        return this.limit;
    }

    public boolean isIgnoreGrowing() {
        return this.ignoreGrowing;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String toString() {
        return "QueryParam{databaseName='" + this.databaseName + '\'' + ", collectionName='" + this.collectionName + '\'' + ", partitionNames=" + this.partitionNames + ", outFields=" + this.outFields + ", expr='" + this.expr + '\'' + ", travelTimestamp=" + this.travelTimestamp + ", guaranteeTimestamp=" + this.guaranteeTimestamp + ", gracefulTime=" + this.gracefulTime + ", consistencyLevel=" + (Object)((Object)this.consistencyLevel) + ", offset=" + this.offset + ", limit=" + this.limit + ", ignoreGrowing=" + this.ignoreGrowing + '}';
    }

    public static class Builder {
        private String databaseName;
        private String collectionName;
        private final List<String> partitionNames = Lists.newArrayList();
        private final List<String> outFields = new ArrayList<String>();
        private String expr = "";
        private Long travelTimestamp = 0L;
        private Long gracefulTime = 5000L;
        private Long guaranteeTimestamp = Constant.GUARANTEE_EVENTUALLY_TS;
        private ConsistencyLevelEnum consistencyLevel = null;
        private Long offset = 0L;
        private Long limit = 0L;
        private Boolean ignoreGrowing = Boolean.FALSE;

        private Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withCollectionName(String collectionName) {
            if (collectionName == null) {
                throw new IllegalArgumentException("collectionName cannot be null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withConsistencyLevel(ConsistencyLevelEnum consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        public Builder withPartitionNames(List<String> partitionNames) {
            if (partitionNames == null) {
                throw new IllegalArgumentException("partitionNames cannot be null");
            }
            partitionNames.forEach(this::addPartitionName);
            return this;
        }

        public Builder addPartitionName(String partitionName) {
            if (partitionName == null) {
                throw new IllegalArgumentException("partitionName cannot be null");
            }
            if (!this.partitionNames.contains(partitionName)) {
                this.partitionNames.add(partitionName);
            }
            return this;
        }

        public Builder withOutFields(List<String> outFields) {
            if (outFields == null) {
                throw new IllegalArgumentException("outFields cannot be null");
            }
            outFields.forEach(this::addOutField);
            return this;
        }

        public Builder addOutField(String fieldName) {
            if (fieldName == null) {
                throw new IllegalArgumentException("fieldName cannot be null");
            }
            if (!this.outFields.contains(fieldName)) {
                this.outFields.add(fieldName);
            }
            return this;
        }

        public Builder withExpr(String expr) {
            if (expr == null) {
                throw new IllegalArgumentException("expr cannot be null");
            }
            this.expr = expr;
            return this;
        }

        public Builder withOffset(Long offset) {
            if (offset == null) {
                throw new IllegalArgumentException("offset cannot be null");
            }
            this.offset = offset;
            return this;
        }

        public Builder withLimit(Long limit) {
            if (limit == null) {
                throw new IllegalArgumentException("limit cannot be null");
            }
            this.limit = limit;
            return this;
        }

        public Builder withIgnoreGrowing(Boolean ignoreGrowing) {
            if (ignoreGrowing == null) {
                throw new IllegalArgumentException("ignoreGrowing cannot be null");
            }
            this.ignoreGrowing = ignoreGrowing;
            return this;
        }

        public QueryParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            ParamUtils.CheckNullString(this.expr, "Expression");
            if (this.travelTimestamp < 0L) {
                throw new ParamException("The travel timestamp must be greater than 0");
            }
            if (this.guaranteeTimestamp < 0L) {
                throw new ParamException("The guarantee timestamp must be greater than 0");
            }
            if (this.offset < 0L) {
                throw new ParamException("The offset value cannot be less than 0");
            }
            if (this.limit < 0L) {
                throw new ParamException("The limit value cannot be less than 0");
            }
            return new QueryParam(this);
        }
    }
}

