/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.collection;

import io.milvus.exception.ParamException;
import io.milvus.grpc.ShowType;
import io.milvus.param.ParamUtils;
import java.util.ArrayList;
import java.util.List;

public class ShowCollectionsParam {
    private final List<String> collectionNames;
    private final ShowType showType;
    private final String databaseName;

    private ShowCollectionsParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Builder cannot be null");
        }
        this.collectionNames = builder.collectionNames;
        this.showType = builder.showType;
        this.databaseName = builder.databaseName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public List<String> getCollectionNames() {
        return this.collectionNames;
    }

    public ShowType getShowType() {
        return this.showType;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String toString() {
        return "ShowCollectionsParam{collectionNames=" + this.collectionNames + ", showType=" + (Object)((Object)this.showType) + ", databaseName='" + this.databaseName + '\'' + '}';
    }

    public static final class Builder {
        private final List<String> collectionNames = new ArrayList<String>();
        private ShowType showType = ShowType.All;
        private String databaseName;

        private Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withCollectionNames(List<String> collectionNames) {
            if (collectionNames == null) {
                throw new IllegalArgumentException("CollectionNames cannot be null");
            }
            collectionNames.forEach(this::addCollectionName);
            return this;
        }

        public Builder withShowType(ShowType showType) {
            this.showType = showType;
            return this;
        }

        public Builder addCollectionName(String collectionName) {
            if (collectionName == null) {
                throw new IllegalArgumentException("CollectionName cannot be null");
            }
            if (!this.collectionNames.contains(collectionName)) {
                this.collectionNames.add(collectionName);
            }
            return this;
        }

        public ShowCollectionsParam build() throws ParamException {
            if (!this.collectionNames.isEmpty()) {
                for (String collectionName : this.collectionNames) {
                    ParamUtils.CheckNullEmptyString(collectionName, "Collection name");
                }
                this.showType = ShowType.InMemory;
            }
            return new ShowCollectionsParam(this);
        }
    }
}

