/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.alias;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;

public class CreateAliasParam {
    private final String collectionName;
    private final String databaseName;
    private final String alias;

    private CreateAliasParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("builder cannot be null");
        }
        this.collectionName = builder.collectionName;
        this.databaseName = builder.databaseName;
        this.alias = builder.alias;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getAlias() {
        return this.alias;
    }

    public String toString() {
        return "CreateAliasParam{collectionName='" + this.collectionName + '\'' + ", databaseName='" + this.databaseName + '\'' + ", alias='" + this.alias + '\'' + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String collectionName;
        private String databaseName;
        private String alias;

        private Builder() {
        }

        public Builder withCollectionName(String collectionName) {
            if (collectionName == null) {
                throw new IllegalArgumentException("collectionName cannot be null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withAlias(String alias) {
            if (alias == null) {
                throw new IllegalArgumentException("alias cannot be null");
            }
            this.alias = alias;
            return this;
        }

        public CreateAliasParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            ParamUtils.CheckNullEmptyString(this.alias, "Alias");
            return new CreateAliasParam(this);
        }
    }
}

