/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.collection;

import io.milvus.exception.ParamException;
import io.milvus.param.collection.FieldType;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class CollectionSchemaParam {
    private final List<FieldType> fieldTypes;
    private final boolean enableDynamicField;

    private CollectionSchemaParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.fieldTypes = builder.fieldTypes;
        this.enableDynamicField = builder.enableDynamicField;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public List<FieldType> getFieldTypes() {
        return this.fieldTypes;
    }

    public boolean isEnableDynamicField() {
        return this.enableDynamicField;
    }

    public String toString() {
        return "CollectionSchemaParam(fieldTypes=" + this.getFieldTypes() + ", enableDynamicField=" + this.isEnableDynamicField() + ")";
    }

    public static final class Builder {
        private final List<FieldType> fieldTypes = new ArrayList<FieldType>();
        private boolean enableDynamicField;

        private Builder() {
        }

        public Builder withEnableDynamicField(boolean enableDynamicField) {
            this.enableDynamicField = enableDynamicField;
            return this;
        }

        public Builder withFieldTypes(@NonNull List<FieldType> fieldTypes) {
            if (fieldTypes == null) {
                throw new NullPointerException("fieldTypes is marked non-null but is null");
            }
            this.fieldTypes.addAll(fieldTypes);
            return this;
        }

        public Builder addFieldType(@NonNull FieldType fieldType) {
            if (fieldType == null) {
                throw new NullPointerException("fieldType is marked non-null but is null");
            }
            this.fieldTypes.add(fieldType);
            return this;
        }

        public CollectionSchemaParam build() throws ParamException {
            if (this.fieldTypes.isEmpty()) {
                throw new ParamException("Field numbers must be larger than 0");
            }
            boolean hasPartitionKey = false;
            for (FieldType fieldType : this.fieldTypes) {
                if (fieldType == null) {
                    throw new ParamException("Collection field cannot be null");
                }
                if (!fieldType.isPartitionKey()) continue;
                if (hasPartitionKey) {
                    throw new ParamException("Only one partition key field is allowed in a collection");
                }
                hasPartitionKey = true;
            }
            return new CollectionSchemaParam(this);
        }
    }
}

