/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter.storage.client;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.milvus.bulkwriter.storage.StorageClient;
import io.minio.BucketExistsArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.credentials.Provider;
import io.minio.credentials.StaticProvider;
import java.io.InputStream;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioStorageClient
extends MinioClient
implements StorageClient {
    private static final Logger logger = LoggerFactory.getLogger(MinioStorageClient.class);

    protected MinioStorageClient(MinioClient client, Multimap<String, String> extraHeader) {
        super(client);
    }

    public static MinioStorageClient getStorageClient(String endpoint, String accessKey, String secretKey, String sessionToken, String region, OkHttpClient httpClient) {
        HashMultimap extraHeader = HashMultimap.create();
        MinioClient.Builder minioClientBuilder = MinioClient.builder().endpoint(endpoint).credentialsProvider((Provider)new StaticProvider(accessKey, secretKey, sessionToken));
        if (StringUtils.isNotEmpty((CharSequence)region)) {
            minioClientBuilder.region(region);
        }
        if (httpClient != null) {
            minioClientBuilder.httpClient(httpClient);
        }
        return new MinioStorageClient(minioClientBuilder.build(), (Multimap<String, String>)extraHeader);
    }

    @Override
    public Long getObjectEntity(String bucketName, String objectKey) throws Exception {
        StatObjectArgs statObjectArgs = (StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucketName)).object(objectKey)).build();
        StatObjectResponse statObject = this.statObject(statObjectArgs);
        return statObject.size();
    }

    @Override
    public void putObjectStream(InputStream inputStream, long contentLength, String bucketName, String objectKey) throws Exception {
        PutObjectArgs putObjectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(objectKey)).stream(inputStream, contentLength, 0x500000L).build();
        this.putObject(putObjectArgs);
    }

    @Override
    public boolean checkBucketExist(String bucketName) throws Exception {
        BucketExistsArgs bucketExistsArgs = (BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build();
        return this.bucketExists(bucketExistsArgs);
    }
}

