/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param;

import io.milvus.exception.ParamException;
import lombok.NonNull;

public class RetryParam {
    private int maxRetryTimes;
    private long initialBackOffMs;
    private long maxBackOffMs;
    private int backOffMultiplier;
    private boolean retryOnRateLimie;

    protected RetryParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.maxRetryTimes = builder.maxRetryTimes;
        this.initialBackOffMs = builder.initialBackOffMs;
        this.maxBackOffMs = builder.maxBackOffMs;
        this.backOffMultiplier = builder.backOffMultiplier;
        this.retryOnRateLimie = builder.retryOnRateLimie;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public long getInitialBackOffMs() {
        return this.initialBackOffMs;
    }

    public long getMaxBackOffMs() {
        return this.maxBackOffMs;
    }

    public int getBackOffMultiplier() {
        return this.backOffMultiplier;
    }

    public boolean isRetryOnRateLimie() {
        return this.retryOnRateLimie;
    }

    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    public void setInitialBackOffMs(long initialBackOffMs) {
        this.initialBackOffMs = initialBackOffMs;
    }

    public void setMaxBackOffMs(long maxBackOffMs) {
        this.maxBackOffMs = maxBackOffMs;
    }

    public void setBackOffMultiplier(int backOffMultiplier) {
        this.backOffMultiplier = backOffMultiplier;
    }

    public void setRetryOnRateLimie(boolean retryOnRateLimie) {
        this.retryOnRateLimie = retryOnRateLimie;
    }

    public String toString() {
        return "RetryParam(maxRetryTimes=" + this.getMaxRetryTimes() + ", initialBackOffMs=" + this.getInitialBackOffMs() + ", maxBackOffMs=" + this.getMaxBackOffMs() + ", backOffMultiplier=" + this.getBackOffMultiplier() + ", retryOnRateLimie=" + this.isRetryOnRateLimie() + ")";
    }

    public static class Builder {
        private int maxRetryTimes = 75;
        private long initialBackOffMs = 10L;
        private long maxBackOffMs = 3000L;
        private int backOffMultiplier = 3;
        private boolean retryOnRateLimie = true;

        protected Builder() {
        }

        public Builder withMaxRetryTimes(int maxRetryTimes) {
            this.maxRetryTimes = maxRetryTimes;
            return this;
        }

        public Builder withInitialBackOffMs(long initialBackOffMs) {
            this.initialBackOffMs = initialBackOffMs;
            return this;
        }

        public Builder withMaxBackOffMs(long maxBackOffMs) {
            this.maxBackOffMs = maxBackOffMs;
            return this;
        }

        public Builder withBackOffMultiplier(int backOffMultiplier) {
            this.backOffMultiplier = backOffMultiplier;
            return this;
        }

        public Builder withRetryOnRateLimie(boolean retryOnRateLimie) {
            this.retryOnRateLimie = retryOnRateLimie;
            return this;
        }

        public RetryParam build() throws ParamException {
            if ((long)this.maxRetryTimes <= 0L) {
                throw new ParamException("Max retry time value must be positive!");
            }
            if (this.initialBackOffMs <= 0L) {
                throw new ParamException("The initial time interval must be positive!");
            }
            if (this.maxBackOffMs <= 0L) {
                throw new ParamException("The max time interval must be positive!");
            }
            if ((long)this.backOffMultiplier <= 0L) {
                throw new ParamException("The multiplier to increase time interval must be positive!");
            }
            return new RetryParam(this);
        }

        public int getMaxRetryTimes() {
            return this.maxRetryTimes;
        }

        public long getInitialBackOffMs() {
            return this.initialBackOffMs;
        }

        public long getMaxBackOffMs() {
            return this.maxBackOffMs;
        }

        public int getBackOffMultiplier() {
            return this.backOffMultiplier;
        }

        public boolean isRetryOnRateLimie() {
            return this.retryOnRateLimie;
        }
    }
}

