/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dockerclient;

import com.github.dockerjava.api.model.AuthConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.github.dockerjava.core.DockerClientConfig;
import org.testcontainers.shaded.com.github.dockerjava.core.DockerClientConfigDelegate;
import org.testcontainers.utility.AuthConfigUtil;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.RegistryAuthLocator;

class AuthDelegatingDockerClientConfig
extends DockerClientConfigDelegate {
    private static final Logger log = LoggerFactory.getLogger(AuthDelegatingDockerClientConfig.class);

    public AuthDelegatingDockerClientConfig(DockerClientConfig delegate) {
        super(delegate);
    }

    @Override
    public AuthConfig effectiveAuthConfig(String imageName) {
        AuthConfig fallbackAuthConfig;
        try {
            fallbackAuthConfig = super.effectiveAuthConfig(imageName);
        }
        catch (Exception e) {
            log.debug("Delegate call to effectiveAuthConfig failed with cause: '{}'. Resolution of auth config will continue using RegistryAuthLocator.", (Object)e.getMessage());
            fallbackAuthConfig = new AuthConfig();
        }
        DockerImageName parsed = DockerImageName.parse(imageName);
        AuthConfig effectiveAuthConfig = RegistryAuthLocator.instance().lookupAuthConfig(parsed, fallbackAuthConfig);
        log.debug("Effective auth config [{}]", (Object)AuthConfigUtil.toSafeString(effectiveAuthConfig));
        return effectiveAuthConfig;
    }
}

