/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.wait.strategy;

import org.testcontainers.containers.wait.strategy.DockerHealthcheckWaitStrategy;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.ShellStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class Wait {
    public static WaitStrategy defaultWaitStrategy() {
        return Wait.forListeningPort();
    }

    public static HostPortWaitStrategy forListeningPort() {
        return new HostPortWaitStrategy();
    }

    public static HttpWaitStrategy forHttp(String path) {
        return new HttpWaitStrategy().forPath(path);
    }

    public static HttpWaitStrategy forHttps(String path) {
        return Wait.forHttp(path).usingTls();
    }

    public static LogMessageWaitStrategy forLogMessage(String regex, int times) {
        return new LogMessageWaitStrategy().withRegEx(regex).withTimes(times);
    }

    public static DockerHealthcheckWaitStrategy forHealthcheck() {
        return new DockerHealthcheckWaitStrategy();
    }

    public static ShellStrategy forSuccessfulCommand(String command) {
        return new ShellStrategy().withCommand(command);
    }
}

