/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.core;

import io.micronaut.context.env.ActiveEnvironment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.env.PropertySourceLoader;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.value.PropertyResolver;
import io.micronaut.testresources.core.PropertyExpressionProducer;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class LazyTestResourcesPropertySourceLoader
implements PropertySourceLoader {
    private final PropertyExpressionProducer producer;

    public LazyTestResourcesPropertySourceLoader(PropertyExpressionProducer producer) {
        this.producer = producer;
    }

    protected final PropertyExpressionProducer getProducer() {
        return this.producer;
    }

    @Override
    public Optional<PropertySource> load(String resourceName, ResourceLoader resourceLoader) {
        return Optional.of(new LazyPropertySource(resourceLoader));
    }

    @Override
    public Optional<PropertySource> loadEnv(String resourceName, ResourceLoader resourceLoader, ActiveEnvironment activeEnvironment) {
        return this.load(resourceName, resourceLoader);
    }

    @Override
    public Map<String, Object> read(String name, InputStream input) {
        return Collections.emptyMap();
    }

    private final class LazyPropertySource
    implements PropertySource,
    Ordered {
        private final ResourceLoader resourceLoader;
        private List<String> keys;

        private LazyPropertySource(ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader;
        }

        @Override
        public int getOrder() {
            return Integer.MAX_VALUE;
        }

        @Override
        public String getName() {
            return "test resources";
        }

        @Override
        public Object get(String key) {
            return "${auto.test.resources." + key + "}";
        }

        @Override
        public Iterator<String> iterator() {
            this.computeKeys();
            return this.keys.iterator();
        }

        private void computeKeys() {
            if (this.keys == null) {
                if (this.resourceLoader instanceof PropertyResolver) {
                    PropertyResolver propertyResolver = (PropertyResolver)((Object)this.resourceLoader);
                    Map<String, Collection<String>> entries = LazyTestResourcesPropertySourceLoader.this.producer.getPropertyEntries().stream().collect(Collectors.toMap(k -> k, propertyResolver::getPropertyEntries));
                    Map<String, Object> testResourcesConfig = propertyResolver.getProperties("test-resources");
                    this.keys = LazyTestResourcesPropertySourceLoader.this.producer.produceKeys(this.resourceLoader, entries, testResourcesConfig).stream().filter(key -> !propertyResolver.containsProperties((String)key)).collect(Collectors.toList());
                } else {
                    this.keys = LazyTestResourcesPropertySourceLoader.this.producer.produceKeys(this.resourceLoader, Collections.emptyMap(), Collections.emptyMap());
                }
            }
        }
    }
}

