/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.util;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.json.tree.JsonNode;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.LimitingStream;
import io.micronaut.serde.exceptions.InvalidFormatException;
import io.micronaut.serde.exceptions.SerdeException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

@Internal
public abstract class JsonNodeDecoder
extends LimitingStream
implements Decoder {
    private JsonNodeDecoder(LimitingStream.RemainingLimits remainingLimits) {
        super(remainingLimits);
    }

    public static JsonNodeDecoder create(JsonNode node, LimitingStream.RemainingLimits remainingLimits) {
        return new Buffered(node, remainingLimits);
    }

    protected abstract JsonNode peekValue();

    @Override
    public Decoder decodeArray(Argument<?> type) throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isArray()) {
            this.skipValue();
            return new Array(peeked, this.childLimits());
        }
        throw this.createDeserializationException("Not an array", null);
    }

    @Override
    public Decoder decodeObject(Argument<?> type) throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isObject()) {
            this.skipValue();
            return new Obj(peeked, this.childLimits());
        }
        throw this.createDeserializationException("Not an array", null);
    }

    @Override
    public String decodeString() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isString()) {
            this.skipValue();
            return peeked.getStringValue();
        }
        throw this.createDeserializationException("Not a string", JsonNodeDecoder.toArbitrary(this.peekValue()));
    }

    @Override
    public boolean decodeBoolean() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isBoolean()) {
            this.skipValue();
            return peeked.getBooleanValue();
        }
        throw this.createDeserializationException("Not a boolean", JsonNodeDecoder.toArbitrary(this.peekValue()));
    }

    @Override
    public byte decodeByte() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNumber()) {
            this.skipValue();
            return (byte)peeked.getIntValue();
        }
        throw this.createDeserializationException("Not a number", JsonNodeDecoder.toArbitrary(this.peekValue()));
    }

    @Override
    public short decodeShort() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNumber()) {
            this.skipValue();
            return (short)peeked.getIntValue();
        }
        throw this.createDeserializationException("Not a number", JsonNodeDecoder.toArbitrary(this.peekValue()));
    }

    @Override
    public char decodeChar() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNumber()) {
            this.skipValue();
            return (char)peeked.getIntValue();
        }
        throw this.createDeserializationException("Not a number", JsonNodeDecoder.toArbitrary(this.peekValue()));
    }

    @Override
    public int decodeInt() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNumber()) {
            this.skipValue();
            return peeked.getIntValue();
        }
        throw this.createDeserializationException("Not a number", JsonNodeDecoder.toArbitrary(this.peekValue()));
    }

    @Override
    public long decodeLong() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNumber()) {
            this.skipValue();
            return peeked.getLongValue();
        }
        throw this.createDeserializationException("Not a number", JsonNodeDecoder.toArbitrary(this.peekValue()));
    }

    @Override
    public float decodeFloat() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNumber()) {
            this.skipValue();
            return peeked.getFloatValue();
        }
        throw this.createDeserializationException("Not a number", JsonNodeDecoder.toArbitrary(this.peekValue()));
    }

    @Override
    public double decodeDouble() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNumber()) {
            this.skipValue();
            return peeked.getDoubleValue();
        }
        throw this.createDeserializationException("Not a number", JsonNodeDecoder.toArbitrary(this.peekValue()));
    }

    @Override
    public BigInteger decodeBigInteger() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNumber()) {
            this.skipValue();
            return peeked.getBigIntegerValue();
        }
        throw this.createDeserializationException("Not a number", JsonNodeDecoder.toArbitrary(this.peekValue()));
    }

    @Override
    public BigDecimal decodeBigDecimal() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNumber()) {
            this.skipValue();
            return peeked.getBigDecimalValue();
        }
        throw this.createDeserializationException("Not a number", JsonNodeDecoder.toArbitrary(this.peekValue()));
    }

    @Override
    public boolean decodeNull() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNull()) {
            this.skipValue();
            return true;
        }
        return false;
    }

    @Override
    public Object decodeArbitrary() throws IOException {
        return JsonNodeDecoder.toArbitrary(this.decodeNode());
    }

    @Override
    @NonNull
    public JsonNode decodeNode() throws IOException {
        JsonNode node = this.peekValue();
        this.skipValue();
        return node;
    }

    private static Object toArbitrary(JsonNode node) {
        if (node.isNull()) {
            return null;
        }
        if (node.isNumber()) {
            return node.getNumberValue();
        }
        if (node.isBoolean()) {
            return node.getBooleanValue();
        }
        if (node.isString()) {
            return node.getStringValue();
        }
        if (node.isArray()) {
            ArrayList<Object> transformed = new ArrayList<Object>();
            for (JsonNode value : node.values()) {
                transformed.add(JsonNodeDecoder.toArbitrary(value));
            }
            return transformed;
        }
        if (node.isObject()) {
            LinkedHashMap<String, Object> transformed = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, JsonNode> entry : node.entries()) {
                transformed.put(entry.getKey(), JsonNodeDecoder.toArbitrary(entry.getValue()));
            }
            return transformed;
        }
        throw new AssertionError(node);
    }

    @Override
    public Decoder decodeBuffer() throws IOException {
        JsonNode peeked = this.peekValue();
        this.skipValue();
        return new Buffered(peeked, this.ourLimits());
    }

    @Override
    public IOException createDeserializationException(String message, Object invalidValue) {
        if (invalidValue != null) {
            return new InvalidFormatException(message, null, invalidValue);
        }
        return new SerdeException(message);
    }

    private static class Buffered
    extends JsonNodeDecoder {
        private final JsonNode node;
        private boolean complete = false;

        Buffered(JsonNode node, LimitingStream.RemainingLimits remainingLimits) {
            super(remainingLimits);
            this.node = node;
        }

        @Override
        public boolean hasNextArrayValue() {
            return false;
        }

        @Override
        public String decodeKey() {
            throw new IllegalStateException("Can't be called on buffered node");
        }

        @Override
        public void skipValue() {
            if (this.complete) {
                throw new IllegalStateException("Already drained");
            }
            this.complete = true;
        }

        @Override
        public void finishStructure(boolean consumeLeftElements) {
            throw new IllegalStateException("Can't be called on buffered node");
        }

        @Override
        protected JsonNode peekValue() {
            return this.node;
        }
    }

    private static class Array
    extends JsonNodeDecoder {
        private final Iterator<JsonNode> iterator;
        private JsonNode peeked;

        Array(JsonNode node, LimitingStream.RemainingLimits remainingLimits) {
            super(remainingLimits);
            this.iterator = node.values().iterator();
            this.skipValue();
        }

        @Override
        public boolean hasNextArrayValue() {
            return this.peeked != null;
        }

        @Override
        public String decodeKey() {
            throw new IllegalStateException("Arrays have no keys");
        }

        @Override
        public void skipValue() {
            this.peeked = this.iterator.hasNext() ? this.iterator.next() : null;
        }

        @Override
        public void finishStructure(boolean consumeLeftElements) {
            if (!consumeLeftElements && this.peeked != null) {
                throw new IllegalStateException("Not all elements have been consumed yet");
            }
        }

        @Override
        protected JsonNode peekValue() {
            if (this.peeked == null) {
                throw new IllegalStateException("No more elements");
            }
            return this.peeked;
        }
    }

    private static class Obj
    extends JsonNodeDecoder {
        private final Iterator<Map.Entry<String, JsonNode>> iterator;
        private JsonNode nextValue = null;

        Obj(JsonNode node, LimitingStream.RemainingLimits remainingLimits) {
            super(remainingLimits);
            this.iterator = node.entries().iterator();
        }

        @Override
        protected JsonNode peekValue() {
            if (this.nextValue == null) {
                throw new IllegalStateException("Field name not parsed yet");
            }
            return this.nextValue;
        }

        @Override
        public void skipValue() {
            if (this.nextValue == null) {
                throw new IllegalStateException("Field name not parsed yet");
            }
            this.nextValue = null;
        }

        @Override
        public boolean hasNextArrayValue() {
            return false;
        }

        @Override
        public String decodeKey() {
            if (this.nextValue != null) {
                throw new IllegalStateException("Field value not parsed yet");
            }
            if (this.iterator.hasNext()) {
                Map.Entry<String, JsonNode> next = this.iterator.next();
                this.nextValue = next.getValue();
                return next.getKey();
            }
            return null;
        }

        @Override
        public void finishStructure(boolean consumeLeftElements) {
            if (!consumeLeftElements && (this.nextValue != null || this.iterator.hasNext())) {
                throw new IllegalStateException("Not all elements have been consumed yet");
            }
        }
    }
}

