/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.type.Argument;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Serde;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.serdes.CustomizedObjectArrayDeserializer;
import io.micronaut.serde.support.serdes.CustomizedObjectArraySerializer;
import io.micronaut.serde.support.serdes.StringArraySerializer;
import io.micronaut.serde.util.CustomizableDeserializer;
import io.micronaut.serde.util.CustomizableSerializer;

public class ObjectArraySerde
implements Serde<Object[]>,
CustomizableSerializer<Object[]>,
CustomizableDeserializer<Object[]> {
    @Override
    public Deserializer<Object[]> createSpecific(Deserializer.DecoderContext context, Argument<? super Object[]> type) throws SerdeException {
        Argument<Object> componentType = Argument.of(type.getType().getComponentType());
        Deserializer<?> deserializer = context.findDeserializer(componentType).createSpecific(context, componentType);
        return new CustomizedObjectArrayDeserializer(componentType, deserializer);
    }

    @Override
    public Serializer<Object[]> createSpecific(Serializer.EncoderContext context, Argument<? extends Object[]> type) throws SerdeException {
        Class<?> arrayItemType = type.getType().getComponentType();
        if (arrayItemType == String.class) {
            return StringArraySerializer.INSTANCE;
        }
        Argument<Object> componentType = Argument.of(arrayItemType);
        Serializer<Object> serializer = context.findSerializer(componentType).createSpecific(context, componentType);
        return new CustomizedObjectArraySerializer(componentType, serializer);
    }
}

