/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.support.serdes.TemporalSerde;
import java.io.IOException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.util.Locale;

@Internal
final class FormattedTemporalSerde<T extends TemporalAccessor>
implements TemporalSerde<T> {
    final DateTimeFormatter formatter;
    final TemporalQuery<T> query;

    FormattedTemporalSerde(@NonNull String pattern, @NonNull AnnotationMetadata annotationMetadata, TemporalQuery<T> query) {
        Locale locale = annotationMetadata.stringValue(SerdeConfig.class, "locale").map(StringUtils::parseLocale).orElse(null);
        DateTimeFormatter f = locale != null ? DateTimeFormatter.ofPattern(pattern, locale) : DateTimeFormatter.ofPattern(pattern);
        ZoneId zone = annotationMetadata.stringValue(SerdeConfig.class, "timezone").map(ZoneId::of).orElse(UTC);
        this.formatter = f.withZone(zone);
        this.query = query;
    }

    FormattedTemporalSerde(DateTimeFormatter formatter, TemporalQuery<T> query) {
        this.formatter = formatter;
        this.query = query;
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends T> type, T value) throws IOException {
        encoder.encodeString(this.formatter.format((TemporalAccessor)value));
    }

    @Override
    public T deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super T> type) throws IOException {
        String str = decoder.decodeString();
        return (T)((TemporalAccessor)this.formatter.parse((CharSequence)str, this.query()));
    }

    @Override
    public TemporalQuery<T> query() {
        return this.query;
    }
}

