/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.exceptions.SerdeException;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashSet;

@Singleton
final class EnumSetDeserializer<E extends Enum<E>>
implements Deserializer<EnumSet<E>> {
    EnumSetDeserializer() {
    }

    @Override
    public EnumSet<E> deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super EnumSet<E>> type) throws IOException {
        Object[] generics = type.getTypeParameters();
        if (ArrayUtils.isEmpty(generics)) {
            throw new SerdeException("Cannot deserialize raw list");
        }
        Object generic = generics[0];
        Decoder arrayDecoder = decoder.decodeArray();
        HashSet set = new HashSet();
        while (arrayDecoder.hasNextArrayValue()) {
            set.add(Enum.valueOf(generic.getType(), arrayDecoder.decodeString()));
        }
        arrayDecoder.finishStructure();
        return EnumSet.copyOf(set);
    }
}

